% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quint.validate.R
\name{quint.validate}
\alias{quint.validate}
\title{Validation of a Qualitative Interaction Tree}
\usage{
quint.validate(object, B = 10, allresults = FALSE)
}
\arguments{
\item{object}{a (pruned) QUINT tree object of class \code{quint}.}

\item{B}{number of bootstrap samples. Default number is 10; for better accuracy B=1000
is recommended.}

\item{allresults}{option to return an extended list of output. Default is set to FALSE.
See \emph{Value} section for details.}
}
\value{
Returns a list with the following components:
  \item{estopt}{the estimated optimism for either the treatment effect size (biasd) or the
    raw treatment mean difference (biasdif).}
  \item{li}{a data frame with leaf information output similar to the leaf information output
    of the (pruned) QUINT tree object. An extra column is added for the bias-corrected
    differences in treatment outcomes (d or diff). The bias-corrected values are only computed
    for the leaves with the most extreme values, i.e. the largest and smallest treatment effects.
    Hence, the other leaves get the value NA in this column.}
  \item{optd}{a matrix with computed estimated optimism of the treatment effect size per
    bootstrapp tree. The first column contains the difference between the largest and smallest
    effect size of the bootstrapped tree. The second column contains the difference between the
    largest and smallest predicted effect size. Returned when \code{allresults} is set to TRUE and
    \code{crit='es'} is specified in the QUINT object.}
  \item{optdif}{a matrix with computed estimated optimism of the raw mean difference bootstrapped tree.
    The first column contains the difference between the largest and smallest raw mean difference of
    the bootstrapped tree. The second column contains the difference between the
    largest and smallest predicted raw mean difference. Returned when \code{allresults} is set to
    TRUE and \code{crit='es'} is specified in the QUINT object.}
  \item{resultd}{a vector with the estimated overall mean optimism, the mean bias for the smallest
    and for the largest effect size. Returned when \code{allresults} is set to
    TRUE and \code{crit="es"}.}
  \item{resultdif}{a vector with the estimated overall mean optimism, the mean bias for the smallest and
    largest raw mean difference. Returned when \code{allresults} is set to TRUE and \code{crit="dm"}.}
}
\description{
A bootstrap-based validation procedure to estimate the optimism in the effect sizes of a
QUINT tree which gives insight in the generalizability of the results.
}
\details{
In this procedure bootstrap trees are grown of the same leaf size as the (pruned)
  QUINT tree. The bootstrap samples are drawn from the data used to grow the original tree. For every
  bootstrap tree the largest and smallest (i.e., largest negative) treatment mean differences
  (or treatment effect sizes) of two leaves are saved. Treatment mean differences in the
  leaves are then predicted using the original data set as input for each bootstrapped tree.
  From these predictions, the largest and smallest treatment mean differences are saved.
  For each bootstrap tree, the largest predicted treatment effect is subtracted from
  the largest treatment effect in the bootstrap sample. The average of these values
  is the bias (i.e., the optimism) for the largest treatment effects. This is done likewise for
  the smallest treatment effects. Subsequently, the bias is computed as the difference between
  the bias for the largest effects minus the bias for the smallest effects.

  The details of this validaton procedure are described in Appendix C of Dusseldorp & Van Mechelen (2014).
}
\examples{
data(bcrp)
formula1<- I(cesdt1-cesdt3)~cond | nationality+marital+wcht1+age+
  trext+comorbid+disopt1+uncomt1+negsoct1

set.seed(10)
control1<-quint.control(maxl=5,B=2)
quint1<-quint(formula1, data= subset(bcrp,cond<3),control=control1) #Grow a QUINT tree

prquint1<-prune(quint1) #Prune tree to optimal size

set.seed(3)
valquint1<-quint.validate(prquint1, B=5) #estimate the optimism by bootstrapping 5 times
valquint1

}
\references{
Dusseldorp E. and Van Mechelen I. (2014). Qualitative interaction trees:
  a tool to identify qualitative treatment-subgroup interactions.
  \emph{Statistics in Medicine, 33(2)}, 219-237. DOI: 10.1002/sim.5933.
}
\seealso{
\code{\link{quint}}, \code{\link{prune.quint}}, \code{\link{quint.control}}
}
