% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame_nlrq.R
\name{frame_nlrq}
\alias{frame_nlrq}
\title{Visualization of fitting process of non-linear quantile regression:
interior point algorithm}
\usage{
frame_nlrq(formula, data, tau, start)
}
\arguments{
\item{formula}{non-linear quantile regression model}

\item{data}{data frame}

\item{tau}{quantiles}

\item{start}{the initial value of all parameters to estimate, must be a list}
}
\value{
Weighted observations in non-linear quantile regression model fitting using
interior algorithm
}
\description{
This function explore the fitting process of nonlinear
quantile regression
}
\details{
To extentd the linear programming method to the case of
non-linear response functions, Koenker & Park(1996) considered the
nonlinear \eqn{l_{1}} problem
\deqn{min_{t\in R^{p}} \sum{|f_{i}(t)|}}
where, for example,
\deqn{f_{i}(t)=y_i-f_{0}(x_i, t)}
As noted by El Attar et al(1979) a necessary condition for \eqn{t*}
to solve \eqn{min_{t\in R^{p}} \sum{|f_{i}(t)|}} is that there
exists a vector \eqn{d \in [-1, 1]^n} such that
\deqn{J(t*)^{'}d = 0}
\deqn{f(t*)^{'}d = \sum{|f_i(t*)|}}
where \eqn{f(t)=(f_i(t))} and
\eqn{J(t)=(\partial f_i(t)/\partial t_j)}.
Thus, as proposed by Osborne and Watson(1971), one approach to
solving  \eqn{min_{t\in R^{p}} \sum{|f_{i}(t)|}} is to solve a
succession of linearized \eqn{l_1} problems minimizing
\deqn{\sum |f_{i}(t)-J_{i}(t)^{'}\delta|}
}
\examples{
library(tidyr)
library(ggplot2)
library(purrr)
x <- rep(1:25, 20)
y <- SSlogis(x, 10, 12, 2) * rnorm(500, 1, 0.1)
Dat <- data.frame(x = x, y = y)
formula <- y ~ SSlogis(x, Aysm, mid, scal)
nlrq_m <- frame_nlrq(formula, data = Dat, tau = c(0.1, 0.5, 0.9))
weights <- nlrq_m$weights
m <- data.frame(Dat, weights)
m_f <- m \%>\% gather(tau_flag, value, -x, -y)
ggplot(m_f, aes(x = x, y = y)) +
  geom_point(aes(size = value, colour = tau_flag)) +
  facet_wrap(~tau_flag)
}
\author{
Wenjing Wang \email{wenjingwangr@gmail.com}
}
