% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2d.R
\name{vis_lg_mesh}
\alias{vis_lg_mesh}
\title{Visualize triangular mesh with coloured long edges}
\usage{
vis_lg_mesh(distance_edges, benchmark_value, tr_coord_df, distance_col)
}
\arguments{
\item{distance_edges}{The data frame containing the edge information.}

\item{benchmark_value}{The threshold value to determine long edges.}

\item{tr_coord_df}{A data frame containing columns for the x and y coordinates of start and end points.}

\item{distance_col}{The column name in `distance_edges` representing the distances.}
}
\value{
A ggplot object with the triangular mesh plot where long edges are
coloured differently.
}
\description{
This function visualize triangular mesh with coloured long edges.
}
\examples{
num_bins_list <- calc_bins(data = s_curve_noise_umap_scaled, x = "UMAP1",
y = "UMAP2", hex_size = NA, buffer_x = NA, buffer_y = NA)
num_bins_x <- num_bins_list$num_x
num_bins_y <- num_bins_list$num_y
hb_obj <- hex_binning(data = s_curve_noise_umap_scaled,
x = "UMAP1", y = "UMAP2", num_bins_x = num_bins_x,
num_bins_y = num_bins_y, x_start = NA, y_start = NA, buffer_x = NA,
buffer_y = NA, hex_size = NA, col_start = "UMAP")
all_centroids_df <- as.data.frame(do.call(cbind, hb_obj$centroids))
counts_df <- as.data.frame(do.call(cbind, hb_obj$std_cts))
df_bin_centroids <- extract_hexbin_centroids(centroids_df = all_centroids_df, counts_df = counts_df)
tr1_object <- tri_bin_centroids(hex_df = df_bin_centroids, x = "c_x", y = "c_y")
tr_from_to_df <- gen_edges(tri_object = tr1_object)
distance_df <- cal_2d_dist(tr_coord_df = tr_from_to_df, start_x = "x_from",
start_y = "y_from", end_x = "x_to", end_y = "y_to",
select_vars = c("from", "to", "distance"))
vis_lg_mesh(distance_edges = distance_df, benchmark_value = 0.75,
tr_coord_df = tr_from_to_df, distance_col = "distance")

}
