% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/payoffs_list.R
\name{payoffs_list}
\alias{payoffs_list}
\title{Generate Payoff List Based on Quantum Gates and Parameters}
\usage{
payoffs_list(gates, alpha, beta, gamma, theta, alpha2, beta2, gamma2, theta2)
}
\arguments{
\item{gates}{A named list of gate matrices. Each element of the list is a quantum gate matrix
(e.g., T, X, Id, H, Z, S, Y). The names of the list elements are used to create payoff names dynamically.}

\item{alpha}{Numeric value for the first parameter set, defining payoff for v×v.}

\item{beta}{Numeric value for the first parameter set, defining payoff for v×V.}

\item{gamma}{Numeric value for the first parameter set, defining payoff for V×v.}

\item{theta}{Numeric value for the first parameter set, defining payoff for V×V.}

\item{alpha2}{Numeric value for the second parameter set, defining payoff for v×v.}

\item{beta2}{Numeric value for the second parameter set, defining payoff for v×V.}

\item{gamma2}{Numeric value for the second parameter set, defining payoff for V×v.}

\item{theta2}{Numeric value for the second parameter set, defining payoff for V×V.}
}
\value{
A list of payoffs where the list names correspond to the gate combinations,
and the values represent the computed payoffs based on the input parameters and gate matrices.
}
\description{
This function generates a list of payoffs for different combinations of quantum gate matrices.
The payoffs are computed for two sets of parameters, where each set defines different values
for the phenotype payoffs (v and V) in the quantum game model. The names of the payoffs are
dynamically generated based on the provided gate names.
}
\examples{
library(qsimulatR)
gates <- list(
  T = Tgate(2),
  X = X(2),
  Id = Id(2),
  H = H(2),
  Z = Z(2),
  S = S(2),
  Y = Y(2)
)
alpha <- 0.5; beta <- 0.2; gamma <- 0.3; theta <- 0.1
alpha2 <- 0.6; beta2 <- 0.25; gamma2 <- 0.35; theta2 <- 0.15
payoffs_list <- payoffs_list(gates, alpha, beta, gamma, theta, alpha2, beta2, gamma2, theta2)
print(payoffs_list)
}
