% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{vl_3}
\alias{vl_3}
\title{Longitudinal Viral Load Values for HIV Patients (2018-2024)}
\format{
A data frame with 176 rows and 18 variables:
\describe{
\item{ID}{Unique identifier for each patient.}
\item{vl_2018_1}{Viral load for the first measurement in 2018.}
\item{vl_2018_2}{Viral load for the second measurement in 2018.}
\item{vl_2019_1}{Viral load for the first measurement in 2019.}
\item{vl_2019_2}{Viral load for the second measurement in 2019.}
\item{vl_2020_1}{Viral load for the first measurement in 2020.}
\item{vl_2021_1}{Viral load for the first measurement in 2021.}
\item{vl_2021_2}{Viral load for the second measurement in 2021.}
\item{vl_2021_3}{Viral load for the third measurement in 2021.}
\item{vl_2022_1}{Viral load for the first measurement in 2022.}
\item{vl_2022_2}{Viral load for the second measurement in 2022.}
\item{vl_2022_3}{Viral load for the third measurement in 2022.}
\item{vl_2023_1}{Viral load for the first measurement in 2023.}
\item{vl_2023_2}{Viral load for the second measurement in 2023.}
\item{vl_2023_3}{Viral load for the third measurement in 2023.}
\item{vl_2024_1}{Viral load for the first measurement in 2024.}
\item{vl_2024_2}{Viral load for the second measurement in 2024.}
\item{vl_2024_3}{Viral load for the third measurement in 2024.}
}
}
\source{
Clinical data from Hospital Vicente Guerrero, IMSS, HIV Clinic.
}
\usage{
vl_3
}
\description{
Contains longitudinal measurements of viral load for 176
patients from 2018 to 2024. Viral load is a critical marker used to monitor
the effectiveness of HIV treatment by measuring the amount of HIV RNA in the
blood.
}
\details{
The viral load measurements provide insight into the patient's response to
antiretroviral therapy (ART). Lower viral load values, especially
undetectable levels, indicate better control of the infection. Missing
values indicate that no viral load measurement was available for that patient
at that specific time.
}
\examples{
\dontrun{
# Load the dataset
data(vl_3)

# Summarize viral loads for the year 2021
summary(vl_3[, c("cd_2021_1", "cd_2021_2", "cd_2021_3")])
}

}
\keyword{datasets}
