% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazyload_cache.R
\name{lazyload_cache_dir}
\alias{lazyload_cache_dir}
\alias{lazyload_cache_labels}
\title{Lazyload Cache}
\usage{
lazyload_cache_dir(
  path = "./cache",
  envir = parent.frame(),
  ask = FALSE,
  verbose = TRUE,
  full.names = TRUE,
  ...
)

lazyload_cache_labels(
  labels,
  path = "./cache/",
  envir = parent.frame(),
  verbose = TRUE,
  filter,
  full.names = TRUE,
  ...
)
}
\arguments{
\item{path}{the path to the cache directory.}

\item{envir}{the environment to load the objects into}

\item{ask}{if TRUE ask the user to confirm loading each database found in
\code{path}}

\item{verbose}{if TRUE display the chunk labels being loaded}

\item{full.names}{use the full name, i.e., include the path, for the chunk
label? This argument is passed to \code{\link[base]{list.files}}.}

\item{...}{additional arguments passed to \code{\link[base]{list.files}}.}

\item{labels}{a character vector of the chunk labels to load.}

\item{filter}{an optional function passed to \code{\link[base]{lazyLoad}}.
when called on a character vector of object names returns a logical vector:
only objects for which this is true will be loaded.}
}
\description{
Lazyload Cached label(s) or a whole directory.
}
\details{
These functions helpful for loading cached chunks into an interactive R
session.  Consider the following scenario: you use knitr and have cached
chunks for lazyloading.  You've created the document, close up your IDE and
move on to the next project.  Later, you revisit the initial project and need
to retrieve the objects created in the cached chunks.  One option is to
reevaluate all the code, but this could be time consuming.  The other option
is to use \code{lazyload_cache_labels} or \code{lazyload_cache_dir} to
quickly (lazy)load the chunks into an active R session.

Use \code{lazyload_cache_dir} to load a whole directory of cached objects.

Use \code{lazyload_cache_labels} to load and explicit set of cached chunks.
}
