% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/target_market_share.R
\name{target_market_share}
\alias{target_market_share}
\title{Add targets for production, using the market share approach}
\usage{
target_market_share(
  data,
  ald,
  scenario,
  region_isos = r2dii.data::region_isos,
  use_credit_limit = FALSE,
  by_company = FALSE,
  weight_production = TRUE
)
}
\arguments{
\item{data}{A "data.frame" like the output of
\code{\link[r2dii.match:prioritize]{r2dii.match::prioritize()}}.}

\item{ald}{An asset level data frame like \link[r2dii.data:ald_demo]{r2dii.data::ald_demo}.}

\item{scenario}{A scenario data frame like \link[r2dii.data:scenario_demo_2020]{r2dii.data::scenario_demo_2020}.}

\item{region_isos}{A data frame like \link[r2dii.data:region_isos]{r2dii.data::region_isos} (default).}

\item{use_credit_limit}{Logical vector of length 1. \code{FALSE} defaults to using
the column \code{loan_size_outstanding}. Set to \code{TRUE} to use the column
\code{loan_size_credit_limit} instead.}

\item{by_company}{Logical vector of length 1. \code{FALSE} defaults to outputting
\code{production_value} at the portfolio-level. Set to \code{TRUE} to output
\code{production_value} at the company-level.}

\item{weight_production}{Logical vector of length 1. \code{TRUE} defaults to
outputting production, weighted by relative loan-size. Set to \code{FALSE} to
output the unweighted production values.}
}
\value{
A tibble including the summarized columns \code{metric}, \code{production} and
\code{technology_share}. If \code{by_company = TRUE}, the output will also have the
column \code{name_ald}.
}
\description{
This function calculates the portfolio-level production targets, as
calculated using the market share approach applied to each relevant climate
production forecast.
}
\section{Handling grouped data}{

This function ignores existing groups and outputs ungrouped data.
}

\examples{
installed <- requireNamespace("r2dii.data", quietly = TRUE) &&
  requireNamespace("r2dii.match", quietly = TRUE)
if (!installed) stop("Please install r2dii.match and r2dii.data")

library(r2dii.data)
library(r2dii.match)

loanbook <- head(loanbook_demo, 100)
ald <- head(ald_demo, 100)

matched <- loanbook \%>\%
  match_name(ald) \%>\%
  prioritize()

# Calculate targets at portfolio level
matched \%>\%
  target_market_share(
    ald = ald,
    scenario = scenario_demo_2020,
    region_isos = region_isos_demo
  )

# Calculate targets at company level
matched \%>\%
  target_market_share(
    ald = ald,
    scenario = scenario_demo_2020,
    region_isos = region_isos_demo,
    by_company = TRUE
  )

matched \%>\%
  target_market_share(
    ald = ald,
    scenario = scenario_demo_2020,
    region_isos = region_isos_demo,
    # Calculate unweighted targets
    weight_production = FALSE
  )
}
\seealso{
Other functions to calculate scenario targets: 
\code{\link{target_sda}()}
}
\concept{functions to calculate scenario targets}
