% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sector_classifications.R
\docType{data}
\name{sector_classifications}
\alias{sector_classifications}
\title{A view of available sector classification datasets}
\format{
\code{sector_classifications} is a \link{data.frame} with columns:
\itemize{
\item \code{borderline} (character): Flag indicating if 2dii sector and classification
code are a borderline match.
\item \code{code} (character): Formatted code.
\item \code{code_system} (character): Code system.
\item \code{sector} (character): Associated 2dii sector.
}
}
\usage{
sector_classifications
}
\description{
This dataset lists all sector classification code standards used by 'PACTA'
(\url{https://2degrees-investing.org/resource/pacta/}).

Classification datasets help to standardize sector classification codes from
the wild to a relevant subset including 'power', 'oil and gas', 'coal',
'automotive', 'aviation', 'concrete', 'steel', and 'shipping'.
}
\examples{
head(sector_classifications)
}
\seealso{
\link{data_dictionary}.

Other datasets for bridging sector classification codes: 
\code{\link{classification_bridge}}
}
\concept{datasets for bridging sector classification codes}
\keyword{datasets}
