/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dmg.pmml.FieldName;
import org.jpmml.converter.Feature;
import org.jpmml.converter.HasDerivedName;

public class FeatureUtil {
    private FeatureUtil() {
    }

    public static FieldName getName(Feature feature) {
        if (feature instanceof HasDerivedName) {
            HasDerivedName hasDerivedName = (HasDerivedName)((Object)feature);
            return hasDerivedName.getDerivedName();
        }
        return feature.getName();
    }

    public static FieldName createName(String function, Feature feature) {
        return FieldName.create((String)(function + "(" + FeatureUtil.getName(feature).getValue() + ")"));
    }

    public static FieldName createName(String function, Feature feature, int index) {
        return FieldName.create((String)(function + "(" + FeatureUtil.getName(feature).getValue() + ")[" + index + "]"));
    }

    public static FieldName createName(String function, List<? extends Feature> features) {
        Stream<Object> nameStream = features.size() <= 5 ? features.stream().map(feature -> FeatureUtil.getName(feature)) : Stream.of(features.subList(0, 2).stream().map(feature -> FeatureUtil.getName(feature)), Stream.of(FieldName.create((String)"..")), features.subList(features.size() - 2, features.size()).stream().map(feature -> FeatureUtil.getName(feature))).flatMap(x -> x);
        String value = nameStream.map(name -> name.getValue()).collect(Collectors.joining(", ", function + "(", ")"));
        return FieldName.create((String)value);
    }
}

