/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.time_series;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.dmg.pmml.time_series.Level;
import org.dmg.pmml.time_series.SeasonalityExpoSmooth;
import org.dmg.pmml.time_series.TimeSeriesAlgorithm;
import org.dmg.pmml.time_series.TimeValue;
import org.dmg.pmml.time_series.TrendExpoSmooth;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"level", "trendExpoSmooth", "seasonalityExpoSmooth", "timeValues"})
@XmlRootElement(name="ExponentialSmoothing", namespace="http://www.dmg.org/PMML-4_3")
@Added(value=Version.PMML_4_0)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"rmse", "transformation", "level", "trendExpoSmooth", "seasonalityExpoSmooth", "timeValues"})
public class ExponentialSmoothing
extends TimeSeriesAlgorithm {
    @XmlAttribute(name="RMSE")
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="RMSE")
    private Number rmse;
    @XmlAttribute(name="transformation")
    @JsonProperty(value="transformation")
    private Transformation transformation;
    @XmlElement(name="Level", namespace="http://www.dmg.org/PMML-4_3", required=true)
    @JsonProperty(value="Level")
    private Level level;
    @XmlElement(name="Trend_ExpoSmooth", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="Trend_ExpoSmooth")
    private TrendExpoSmooth trendExpoSmooth;
    @XmlElement(name="Seasonality_ExpoSmooth", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="Seasonality_ExpoSmooth")
    private SeasonalityExpoSmooth seasonalityExpoSmooth;
    @XmlElement(name="TimeValue", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="TimeValue")
    private List<TimeValue> timeValues;
    private static final long serialVersionUID = 67305489L;

    public ExponentialSmoothing() {
    }

    @ValueConstructor
    public ExponentialSmoothing(@Property(value="level") Level level) {
        this.level = level;
    }

    public Number getRMSE() {
        return this.rmse;
    }

    public ExponentialSmoothing setRMSE(@Property(value="rmse") Number rmse) {
        this.rmse = rmse;
        return this;
    }

    public Transformation getTransformation() {
        if (this.transformation == null) {
            return Transformation.NONE;
        }
        return this.transformation;
    }

    public ExponentialSmoothing setTransformation(@Property(value="transformation") Transformation transformation) {
        this.transformation = transformation;
        return this;
    }

    public Level getLevel() {
        return this.level;
    }

    public ExponentialSmoothing setLevel(@Property(value="level") Level level) {
        this.level = level;
        return this;
    }

    public TrendExpoSmooth getTrendExpoSmooth() {
        return this.trendExpoSmooth;
    }

    public ExponentialSmoothing setTrendExpoSmooth(@Property(value="trendExpoSmooth") TrendExpoSmooth trendExpoSmooth) {
        this.trendExpoSmooth = trendExpoSmooth;
        return this;
    }

    public SeasonalityExpoSmooth getSeasonalityExpoSmooth() {
        return this.seasonalityExpoSmooth;
    }

    public ExponentialSmoothing setSeasonalityExpoSmooth(@Property(value="seasonalityExpoSmooth") SeasonalityExpoSmooth seasonalityExpoSmooth) {
        this.seasonalityExpoSmooth = seasonalityExpoSmooth;
        return this;
    }

    public boolean hasTimeValues() {
        return this.timeValues != null && this.timeValues.size() > 0;
    }

    public List<TimeValue> getTimeValues() {
        if (this.timeValues == null) {
            this.timeValues = new ArrayList<TimeValue>();
        }
        return this.timeValues;
    }

    public ExponentialSmoothing addTimeValues(TimeValue ... timeValues) {
        this.getTimeValues().addAll(Arrays.asList(timeValues));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getLevel(), this.getTrendExpoSmooth(), this.getSeasonalityExpoSmooth());
            }
            if (status == VisitorAction.CONTINUE && this.hasTimeValues()) {
                status = PMMLObject.traverse(visitor, this.getTimeValues());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum Transformation implements StringValue<Transformation>
    {
        NONE("none"),
        LOGARITHMIC("logarithmic"),
        SQUAREROOT("squareroot");

        private final String value;

        private Transformation(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static Transformation fromValue(String v) {
            for (Transformation c : Transformation.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }
}

