/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model.visitors;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.ReflectionUtil;
import org.jpmml.model.visitors.AbstractVisitor;
import org.jpmml.model.visitors.DoubletonList;
import org.jpmml.model.visitors.SingletonList;

public class ArrayListTransformer
extends AbstractVisitor {
    @Override
    public VisitorAction visit(PMMLObject object) {
        List<Field> fields = ReflectionUtil.getFields(object.getClass());
        for (Field field : fields) {
            List<?> transformedList;
            ArrayList list;
            Object value = ReflectionUtil.getFieldValue(field, object);
            if (!(value instanceof ArrayList) || !value.getClass().equals(ArrayList.class) || (list = (ArrayList)value) == (transformedList = this.transform(list))) continue;
            ReflectionUtil.setFieldValue(field, object, transformedList);
        }
        return super.visit(object);
    }

    public List<?> transform(List<?> list) {
        if (list.size() == 0) {
            return Collections.emptyList();
        }
        if (list.size() == 1) {
            return new SingletonList(list.get(0));
        }
        if (list.size() == 2) {
            return new DoubletonList(list.get(0), list.get(1));
        }
        return list;
    }
}

