/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.OpType;
import org.dmg.pmml.general_regression.GeneralRegressionModel;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.FortranMatrixUtil;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.general_regression.GeneralRegressionModelUtil;
import org.jpmml.rexp.Formula;
import org.jpmml.rexp.FormulaUtil;
import org.jpmml.rexp.ModelConverter;
import org.jpmml.rexp.ModelFrameFormulaContext;
import org.jpmml.rexp.RDoubleVector;
import org.jpmml.rexp.RExp;
import org.jpmml.rexp.RExpEncoder;
import org.jpmml.rexp.RGenericVector;
import org.jpmml.rexp.RNumberVector;
import org.jpmml.rexp.RStringVector;

public class MVRConverter
extends ModelConverter<RGenericVector> {
    public MVRConverter(RGenericVector mvr) {
        super(mvr);
    }

    @Override
    public void encodeSchema(RExpEncoder encoder) {
        RGenericVector mvr = (RGenericVector)this.getObject();
        RDoubleVector coefficients = mvr.getDoubleElement("coefficients");
        RExp terms = (RExp)mvr.getElement("terms");
        RGenericVector model = mvr.getGenericElement("model");
        RStringVector rowNames = coefficients.dimnames(0);
        RStringVector columnNames = coefficients.dimnames(1);
        ModelFrameFormulaContext context = new ModelFrameFormulaContext(model);
        Formula formula = FormulaUtil.createFormula(terms, context, encoder);
        FieldName name = FieldName.create((String)((String)columnNames.asScalar()));
        DataField dataField = (DataField)encoder.getField(name);
        encoder.setLabel(dataField);
        FormulaUtil.addFeatures(formula, rowNames, true, encoder);
        this.scaleFeatures(encoder);
    }

    public GeneralRegressionModel encodeModel(Schema schema) {
        RGenericVector mvr = (RGenericVector)this.getObject();
        RDoubleVector coefficients = mvr.getDoubleElement("coefficients");
        RDoubleVector xMeans = mvr.getDoubleElement("Xmeans");
        RDoubleVector yMeans = mvr.getDoubleElement("Ymeans");
        RNumberVector<?> ncomp = mvr.getNumericElement("ncomp");
        RStringVector rowNames = coefficients.dimnames(0);
        RStringVector columnNames = coefficients.dimnames(1);
        RStringVector compNames = coefficients.dimnames(2);
        int rows = rowNames.size();
        int columns = columnNames.size();
        int components = compNames.size();
        List features = schema.getFeatures();
        List featureCoefficients = FortranMatrixUtil.getColumn(coefficients.getValues(), (int)rows, (int)(columns * components), (int)(0 + (ValueUtil.asInt((Number)((Number)ncomp.asScalar())) - 1)));
        Double intercept = yMeans.getValue(0);
        for (int j = 0; j < rowNames.size(); ++j) {
            intercept = intercept - (Double)featureCoefficients.get(j) * xMeans.getValue(j);
        }
        GeneralRegressionModel generalRegressionModel = new GeneralRegressionModel(GeneralRegressionModel.ModelType.GENERALIZED_LINEAR, MiningFunction.REGRESSION, ModelUtil.createMiningSchema((Label)schema.getLabel()), null, null, null).setLinkFunction(GeneralRegressionModel.LinkFunction.IDENTITY);
        GeneralRegressionModelUtil.encodeRegressionTable((GeneralRegressionModel)generalRegressionModel, (List)features, (List)featureCoefficients, (Number)intercept, null);
        return generalRegressionModel;
    }

    private void scaleFeatures(RExpEncoder encoder) {
        RGenericVector mvr = (RGenericVector)this.getObject();
        RDoubleVector scale = mvr.getDoubleElement("scale", false);
        if (scale == null) {
            return;
        }
        List<Feature> features = encoder.getFeatures();
        if (scale.size() != features.size()) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            Double factor = scale.getValue(i);
            if (ValueUtil.isOne((Number)factor)) continue;
            ContinuousFeature continuousFeature = feature.toContinuousFeature();
            Apply apply = PMMLUtil.createApply((String)"/", (Expression[])new Expression[]{continuousFeature.ref(), PMMLUtil.createConstant((Number)factor)});
            DerivedField derivedField = encoder.createDerivedField(FeatureUtil.createName((String)"scale", (Feature)feature), OpType.CONTINUOUS, DataType.DOUBLE, (Expression)apply);
            features.set(i, (Feature)new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField));
        }
    }
}

