/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.BooleanFeature;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.HasDerivedName;
import org.jpmml.converter.InteractionFeature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PowerFeature;
import org.jpmml.converter.ValueUtil;
import org.jpmml.rexp.RDoubleVector;
import org.jpmml.rexp.RExpEncoder;
import org.jpmml.rexp.RExpUtil;

public class Formula {
    private RExpEncoder encoder = null;
    private Map<FieldName, FieldName> validNames = new HashMap<FieldName, FieldName>();
    private BiMap<FieldName, Feature> features = HashBiMap.create();
    private List<Field<?>> fields = new ArrayList();

    public Formula(RExpEncoder encoder) {
        this.setEncoder(encoder);
    }

    public Feature resolveFeature(String name) {
        RExpEncoder encoder = this.getEncoder();
        List<String> variables = Formula.split(name);
        if (variables.size() == 1) {
            return this.resolveFeature(FieldName.create((String)name));
        }
        ArrayList<Feature> variableFeatures = new ArrayList<Feature>();
        for (String variable : variables) {
            Feature variableFeature = this.resolveFeature(FieldName.create((String)variable));
            variableFeatures.add(variableFeature);
        }
        return new InteractionFeature((PMMLEncoder)encoder, FieldName.create((String)name), DataType.DOUBLE, variableFeatures);
    }

    public Feature resolveFeature(FieldName name) {
        Feature feature = this.getFeature(name);
        if (feature == null) {
            throw new IllegalArgumentException(name.getValue());
        }
        return feature;
    }

    public Double getCoefficient(Feature feature, RDoubleVector coefficients) {
        FieldName name = feature.getName();
        if (feature instanceof HasDerivedName) {
            BiMap inverseFeatures = this.features.inverse();
            name = (FieldName)inverseFeatures.get((Object)feature);
        }
        return (Double)coefficients.getElement(name.getValue());
    }

    public Field<?> getField(int index) {
        return this.fields.get(index);
    }

    public void addField(Field<?> field) {
        Apply apply;
        DerivedField derivedField;
        Expression expression;
        RExpEncoder encoder = this.getEncoder();
        ContinuousFeature feature = new ContinuousFeature((PMMLEncoder)encoder, field);
        if (field instanceof DerivedField && (expression = (derivedField = (DerivedField)field).getExpression()) instanceof Apply && Formula.checkApply(apply = (Apply)expression, "pow", FieldRef.class, Constant.class)) {
            List expressions = apply.getExpressions();
            FieldRef fieldRef = (FieldRef)expressions.get(0);
            Constant constant = (Constant)expressions.get(1);
            try {
                String string = ValueUtil.asString((Object)constant.getValue());
                int power = Integer.parseInt(string);
                feature = new PowerFeature((PMMLEncoder)encoder, fieldRef.getField(), DataType.DOUBLE, power);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.putFeature(field.getName(), (Feature)feature);
        this.fields.add(field);
    }

    public void addField(Field<?> field, List<String> categoryNames, List<?> categoryValues) {
        RExpEncoder encoder = this.getEncoder();
        if (categoryNames.size() != categoryValues.size()) {
            throw new IllegalArgumentException();
        }
        Object categoricalFeature = DataType.BOOLEAN.equals((Object)field.getDataType()) && BooleanFeature.VALUES.equals(categoryValues) ? new BooleanFeature((PMMLEncoder)encoder, field) : new CategoricalFeature((PMMLEncoder)encoder, field, categoryValues);
        this.putFeature(field.getName(), (Feature)categoricalFeature);
        for (int i = 0; i < categoryNames.size(); ++i) {
            String categoryName = categoryNames.get(i);
            Object categoryValue = categoryValues.get(i);
            BinaryFeature binaryFeature = new BinaryFeature((PMMLEncoder)encoder, field, categoryValue);
            this.putFeature(FieldName.create((String)(field.getName().getValue() + categoryName)), (Feature)binaryFeature);
        }
        this.fields.add(field);
    }

    private Feature getFeature(FieldName name) {
        Feature feature = (Feature)this.features.get((Object)name);
        if (feature == null && this.validNames.containsKey(name)) {
            feature = (Feature)this.features.get((Object)this.validNames.get(name));
        }
        return feature;
    }

    private void putFeature(FieldName name, Feature feature) {
        FieldName validName = RExpUtil.makeName(name);
        if (!name.equals((Object)validName)) {
            this.validNames.put(validName, name);
        }
        this.features.put((Object)name, (Object)feature);
    }

    public RExpEncoder getEncoder() {
        return this.encoder;
    }

    private void setEncoder(RExpEncoder encoder) {
        this.encoder = encoder;
    }

    static List<String> split(String string) {
        ArrayList<String> result = new ArrayList<String>();
        int pos = 0;
        int i = 0;
        while (i < string.length()) {
            if (string.charAt(i) == ':') {
                int delimBegin = i;
                int delimEnd = i;
                while (delimEnd + 1 < string.length() && string.charAt(delimEnd + 1) == ':') {
                    ++delimEnd;
                }
                if (delimBegin == delimEnd) {
                    result.add(string.substring(pos, delimBegin));
                    pos = delimEnd + 1;
                }
                i = delimEnd + 1;
                continue;
            }
            ++i;
        }
        if (pos <= string.length()) {
            result.add(string.substring(pos));
        }
        return result;
    }

    private static boolean checkApply(Apply apply, String function, Class<? extends Expression> ... expressionClazzes) {
        List expressions;
        if (function.equals(apply.getFunction()) && expressionClazzes.length == (expressions = apply.getExpressions()).size()) {
            for (int i = 0; i < expressionClazzes.length; ++i) {
                Class<? extends Expression> expressionClazz = expressionClazzes[i];
                Expression expression = (Expression)expressions.get(i);
                if (expressionClazz.isInstance(expression)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

