/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segmentation;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PredicateManager;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.xgboost.RegTree;

public abstract class ObjFunction {
    private String name;

    public ObjFunction(String name) {
        this.name = name;
    }

    public abstract Label encodeLabel(String var1, List<?> var2, PMMLEncoder var3);

    public abstract MiningModel encodeMiningModel(List<RegTree> var1, List<Float> var2, float var3, Integer var4, boolean var5, Schema var6);

    public float probToMargin(float value) {
        return value;
    }

    public String getName() {
        return this.name;
    }

    protected static MiningModel createMiningModel(List<RegTree> trees, List<Float> weights, float base_score, Integer ntreeLimit, boolean numeric, Schema schema) {
        Float leafValue;
        Float weight;
        RegTree tree;
        Iterator<Float> weightIt;
        trees = new ArrayList<RegTree>(trees);
        if (weights != null) {
            weights = new ArrayList<Float>(weights);
            if (trees.size() != weights.size()) {
                throw new IllegalArgumentException();
            }
        }
        if (ntreeLimit != null) {
            if (ntreeLimit > trees.size()) {
                throw new IllegalArgumentException("Tree limit " + ntreeLimit + " is greater than the number of trees");
            }
            trees = trees.subList(0, ntreeLimit);
            if (weights != null) {
                weights = weights.subList(0, ntreeLimit);
            }
        }
        ContinuousLabel continuousLabel = (ContinuousLabel)schema.getLabel();
        Schema segmentSchema = schema.toAnonymousSchema();
        PredicateManager predicateManager = new PredicateManager();
        ArrayList<TreeModel> treeModels = new ArrayList<TreeModel>();
        Number intercept = Float.valueOf(base_score);
        boolean equalWeights = true;
        Iterator<RegTree> treeIt = trees.iterator();
        Iterator<Float> iterator = weightIt = weights != null ? weights.iterator() : null;
        while (treeIt.hasNext()) {
            tree = treeIt.next();
            weight = weightIt != null ? weightIt.next() : null;
            leafValue = tree.getLeafValue();
            if (leafValue != null && ValueUtil.isZero((Number)leafValue)) {
                treeIt.remove();
                if (weightIt == null) continue;
                weightIt.remove();
                continue;
            }
            if (weight == null) continue;
            equalWeights &= ValueUtil.isOne((Number)weight);
        }
        if (equalWeights) {
            treeIt = trees.iterator();
            Iterator<Float> iterator2 = weightIt = weights != null ? weights.iterator() : null;
            while (treeIt.hasNext()) {
                tree = treeIt.next();
                Float f = weight = weightIt != null ? weightIt.next() : null;
                leafValue = tree.getLeafValue();
                if (leafValue == null) continue;
                intercept = ValueUtil.add((MathContext)MathContext.FLOAT, (Number)intercept, (Number)leafValue);
                treeIt.remove();
                if (weightIt == null) continue;
                weightIt.remove();
            }
        }
        for (RegTree tree2 : trees) {
            TreeModel treeModel = tree2.encodeTreeModel(numeric, predicateManager, segmentSchema);
            treeModels.add(treeModel);
        }
        MiningModel miningModel = new MiningModel(MiningFunction.REGRESSION, ModelUtil.createMiningSchema((Label)continuousLabel)).setMathContext(MathContext.FLOAT).setSegmentation(MiningModelUtil.createSegmentation((Segmentation.MultipleModelMethod)(equalWeights ? Segmentation.MultipleModelMethod.SUM : Segmentation.MultipleModelMethod.WEIGHTED_SUM), (Segmentation.MissingPredictionTreatment)Segmentation.MissingPredictionTreatment.RETURN_MISSING, treeModels, weights)).setTargets(ModelUtil.createRescaleTargets(null, (Number)intercept, (ContinuousLabel)continuousLabel));
        return miningModel;
    }

    protected static float inverseLogit(float value) {
        return (float)(-Math.log(1.0f / value - 1.0f));
    }

    protected static float inverseExp(float value) {
        return (float)Math.log(value);
    }
}

