/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import java.util.List;
import java.util.Objects;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ScalarLabel;
import org.jpmml.model.ToStringHelper;

public class CategoricalLabel
extends ScalarLabel {
    private List<?> values = null;

    public <F extends Field<F>> CategoricalLabel(F field) {
        this(field.requireName(), field.requireDataType(), PMMLUtil.getValues(field));
    }

    public CategoricalLabel(CategoricalFeature categoricalFeature) {
        this(categoricalFeature.getName(), categoricalFeature.getDataType(), categoricalFeature.getValues());
    }

    public CategoricalLabel(DataType dataType, List<?> values) {
        this(null, dataType, values);
    }

    public CategoricalLabel(String name, DataType dataType, List<?> values) {
        super(name, dataType);
        this.setValues(values);
    }

    @Override
    public CategoricalLabel toRenamedLabel(String name) {
        return new CategoricalLabel(name, this.getDataType(), this.getValues());
    }

    @Override
    public CategoricalLabel toAnonymousLabel() {
        return (CategoricalLabel)super.toAnonymousLabel();
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hashCode(this.getValues());
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof CategoricalLabel) {
            CategoricalLabel that = (CategoricalLabel)object;
            return super.equals(object) && Objects.equals(this.getValues(), that.getValues());
        }
        return false;
    }

    @Override
    protected ToStringHelper toStringHelper() {
        return super.toStringHelper().add("values", this.getValues());
    }

    public int size() {
        List<?> values = this.getValues();
        return values.size();
    }

    public Object getValue(int index) {
        List<?> values = this.getValues();
        return values.get(index);
    }

    public List<?> getValues() {
        return this.values;
    }

    private void setValues(List<?> values) {
        if ((values = Objects.requireNonNull(values)).isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.values = values;
    }
}

