% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtf_nrow.R
\name{rtf_nline_matrix}
\alias{rtf_nline_matrix}
\title{Calculate Number of Lines of a String Matrix}
\usage{
rtf_nline_matrix(text, strwidth, size)
}
\arguments{
\item{text}{a matrix of string}

\item{strwidth}{a matrix of string width in inches}

\item{size}{a matrix of cell size in inches

#' @section Specification:
\if{latex}{
 \itemize{
   \item \code{text} is a matrix of string
   \item \code{strwidth} is a matrix of string width in inches
   \item \code{size} is a matrix of cell size in inches
   \item Return a vector of integer (number of lines)
 }
 }
\if{html}{The contents of this section are shown in PDF user manual only.}}
}
\value{
a vector of integer (number of lines)
}
\description{
Calculate each string matrix (e.g., table body in matrix format) row's maximum number of lines broken to given a specific cell size
}
\examples{
text <- matrix("this is a sentence", nrow = 2, ncol = 2)
strwidth <- matrix(6:9, nrow = 2)
size <- matrix(1:4, nrow = 2)
r2rtf:::rtf_nline_matrix(text = text, strwidth = strwidth, size = size)
}
