% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd.R, R/set.R
\name{m_set_viewer}
\alias{m_set_viewer}
\alias{m_set_width}
\alias{m_set_height}
\alias{m_set_background_color}
\title{Set viewer properties}
\usage{
m_set_width(id, width)

m_set_height(id, height)

m_set_background_color(id, hex, alpha)
}
\arguments{
\item{id}{R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})}

\item{width, height}{Weight and height \code{numeric} in pixels}

\item{hex}{Hex code specified background color, or standard color spec
\code{character}}

\item{alpha}{Alpha level \code{numeric} (default \code{1.0})}
}
\value{
R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})
}
\description{
Functions of setting viewer properties, such as width, height, background
color, etc.
The viewer size can be adjusted automatically under normal circumstances.
}
\examples{
library(r3dmol)

r3dmol() \%>\%
  m_add_model(data = pdb_6zsl, format = "pdb") \%>\%
  m_zoom_to() \%>\%
  m_set_width(300) \%>\%
  m_set_background_color("#666666", alpha = 0.9)
}
