% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSgetoutput.R
\name{SSgetoutput}
\alias{SSgetoutput}
\title{Get output from multiple Stock Synthesis models.}
\usage{
SSgetoutput(keyvec = NULL, dirvec = NULL, getcovar = TRUE,
  getcomp = TRUE, forecast = FALSE, verbose = TRUE, ncols = 210,
  listlists = TRUE, underscore = FALSE, save.lists = FALSE)
}
\arguments{
\item{keyvec}{A vector of strings that are appended to the output files from
each model if models are all in one directory. Default=NULL.}

\item{dirvec}{A vector of directories (full path or relative to working
directory) in which model output is located. Default=NULL.}

\item{getcovar}{Choice to read or not read covar.sso output (saves time and
memory). Default=TRUE.}

\item{getcomp}{Choice to read or not read CompReport.sso output (saves time
and memory). Default=TRUE.}

\item{forecast}{Choice to read or not read forecast quantities.
Default=FALSE.}

\item{verbose}{Print various messages to the command line as the function
runs? Default=TRUE.}

\item{ncols}{Maximum number of columns in Report.sso (same input as for
\code{\link{SS_output}}).  Default=210.}

\item{listlists}{Save output from each model as a element of a list (i.e.
make a list of lists). Default = TRUE.}

\item{underscore}{Add an underscore '_' between any file names and any keys
in keyvec. Default=FALSE.}

\item{save.lists}{Save each list of parsed output as a .Rdata file (with default
filenaming convention based on iteration and date stamp.}
}
\description{
Apply the function \code{\link{SS_output}} multiple times and save output as
individual objects or a list of lists.
}
\author{
Ian Taylor
}
\seealso{
\code{\link{SS_output}} \code{\link{SSsummarize}}
}
\keyword{data}
\keyword{list}
\keyword{manip}

