/*
 * Decompiled with CFR 0.152.
 */
package org.ipea.r5r;

import com.conveyal.r5.common.GeometryUtils;
import com.conveyal.r5.profile.StreetMode;
import com.conveyal.r5.streets.Split;
import com.conveyal.r5.transit.TransportNetwork;
import java.util.concurrent.ForkJoinPool;
import org.ipea.r5r.RDataFrame;

public class SnapFinder {
    protected final ForkJoinPool r5rThreadPool;
    protected final TransportNetwork transportNetwork;
    protected String[] fromIds;
    protected double[] fromLats;
    protected double[] fromLons;
    private StreetMode mode;
    protected int nOrigins;

    public void setMode(String mode) {
        this.mode = StreetMode.valueOf((String)mode);
    }

    public SnapFinder(ForkJoinPool threadPool, TransportNetwork transportNetwork) {
        this.r5rThreadPool = threadPool;
        this.transportNetwork = transportNetwork;
    }

    public void setOrigins(String[] fromIds, double[] fromLats, double[] fromLons) {
        this.fromIds = fromIds;
        this.fromLats = fromLats;
        this.fromLons = fromLons;
        this.nOrigins = fromIds.length;
    }

    public RDataFrame run() {
        RDataFrame snapTable = new RDataFrame(this.nOrigins);
        snapTable.addStringColumn("point_id", "");
        snapTable.addDoubleColumn("lat", 0.0);
        snapTable.addDoubleColumn("lon", 0.0);
        snapTable.addDoubleColumn("snap_lat", 0.0);
        snapTable.addDoubleColumn("snap_lon", 0.0);
        snapTable.addDoubleColumn("distance", 0.0);
        snapTable.addBooleanColumn("found", false);
        for (int index = 0; index < this.nOrigins; ++index) {
            snapTable.append();
            snapTable.set("point_id", this.fromIds[index]);
            snapTable.set("lat", this.fromLats[index]);
            snapTable.set("lon", this.fromLons[index]);
            Split split = this.transportNetwork.streetLayer.findSplit(this.fromLats[index], this.fromLons[index], 1600.0, this.mode);
            if (split != null) {
                double snapLat = (double)split.fixedLat / 1.0E7;
                double snapLon = (double)split.fixedLon / 1.0E7;
                snapTable.set("snap_lat", snapLat);
                snapTable.set("snap_lon", snapLon);
                snapTable.set("distance", GeometryUtils.distance((double)this.fromLats[index], (double)this.fromLons[index], (double)snapLat, (double)snapLon));
                snapTable.set("found", true);
                continue;
            }
            snapTable.set("snap_lat", this.fromLats[index]);
            snapTable.set("snap_lon", this.fromLons[index]);
            snapTable.set("distance", -1.0);
            snapTable.set("found", false);
        }
        return snapTable;
    }
}

