% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r5r_sitrep.R
\name{r5r_sitrep}
\alias{r5r_sitrep}
\title{Generate an r5r situation report to help debug errors}
\usage{
r5r_sitrep()
}
\value{
A \code{list} with information of the versions of the r5r package, Java
and R5 Jar in use, the memory set to Java and user's Session Info.
}
\description{
The function reports a list with the following information:
\itemize{
\item The package version of \code{{r5r}} in use.
\item The installed version of \code{R5.jar}.
\item The Java version in use.
\item The amount of memory set to Java through the \code{java.parameters} option.
\item The user's Session Info.
}
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
r5r_sitrep()
\dontshow{\}) # examplesIf}
}
