% Generated by roxygen2 (4.0.2): do not edit by hand
\name{svds}
\alias{svds}
\alias{svds.dgCMatrix}
\alias{svds.dgRMatrix}
\alias{svds.dgeMatrix}
\alias{svds.dsyMatrix}
\alias{svds.matrix}
\title{Find the Largest k Singular Values/Vectors of a Matrix}
\usage{
svds(A, k, nu = k, nv = k, opts = list(), ...)

\method{svds}{matrix}(A, k, nu = k, nv = k, opts = list(), ...)

\method{svds}{dgeMatrix}(A, k, nu = k, nv = k, opts = list(), ...)

\method{svds}{dgCMatrix}(A, k, nu = k, nv = k, opts = list(), ...)

\method{svds}{dgRMatrix}(A, k, nu = k, nv = k, opts = list(), ...)

\method{svds}{dsyMatrix}(A, k, nu = k, nv = k, opts = list(), ...)
}
\arguments{
\item{A}{The matrix whose truncated SVD is to be computed.}

\item{k}{Number of singular values requested.}

\item{nu}{Number of left singular vectors to be computed. This must
be between 0 and \code{k}.}

\item{nv}{Number of right singular vectors to be computed. This must
be between 0 and \code{k}.}

\item{opts}{Control parameters related to the computing
algorithm. See \strong{Details} below.}

\item{\dots}{Currently not used.}
}
\value{
A list with the following components:
\item{d}{A vector of the computed singular values.}
\item{u}{An \code{m} by \code{nu} matrix whose columns contain
         the left singular vectors. If \code{nu == 0}, \code{NULL}
         will be returned.}
\item{v}{An \code{n} by \code{nv} matrix whose columns contain
         the right singular vectors. If \code{nv == 0}, \code{NULL}
         will be returned.}
\item{nconv}{Number of converged singular values.}
\item{niter}{Number of iterations.}
}
\description{
Given an \eqn{m} by \eqn{n} matrix \eqn{A},
function \code{svds()} can find its largest \eqn{k}
singular values and the corresponding singular vectors.
It is also called the Truncated Singular Value Decomposition
since it only contains a subset of the whole singular triplets.

Currently \code{svds()} supports matrices of the following classes:

\tabular{ll}{
  \code{matrix}     \tab The most commonly used matrix type,
                         defined in \strong{base} package.\cr
  \code{dgeMatrix}  \tab General matrix, equivalent to \code{matrix},
                         defined in \strong{Matrix} package.\cr
  \code{dgCMatrix}  \tab Column oriented sparse matrix, defined in
                         \strong{Matrix} package.\cr
  \code{dgRMatrix}  \tab Row oriented sparse matrix, defined in
                         \strong{Matrix} package.\cr
  \code{dsyMatrix}  \tab Symmetrix matrix, defined in \strong{Matrix}
                         package.
}

Note that when \eqn{A} is symmetric,
SVD reduces to eigen decomposition, so you may consider using
\code{\link{eigs}()} instead.
}
\details{
The \code{opts} argument is a list that can supply any of the
following parameters:

\describe{
\item{\code{ncv}}{Number of Lanzcos basis vectors to use. More vectors
                  will result in faster convergence, but with greater
                  memory use. \code{ncv} must be satisfy
                  \eqn{k < ncv \le p}{k < ncv <= p} where
                  \code{p = min(m, n)}.
                  Default is \code{min(p, max(2*k+1, 20))}.}
\item{\code{tol}}{Precision parameter. Default is 1e-10.}
\item{\code{maxitr}}{Maximum number of iterations. Default is 1000.}
}
}
\examples{
m = 100
n = 20
k = 5
set.seed(111)
A = matrix(rnorm(m * n), m)

svds(A, k)
svds(t(A), k, nu = 0, nv = 3)

## Sparse matrices
library(Matrix)
A[sample(m * n, m * n / 2)] = 0
Asp1 = as(A, "dgCMatrix")
Asp2 = as(A, "dgRMatrix")

svds(Asp1, k)
svds(Asp2, k, nu = 0, nv = 0)
}
\author{
Yixuan Qiu <\url{http://statr.me}>
}
\seealso{
\code{\link[base]{eigen}()}, \code{\link[base]{svd}()},
\code{\link[rARPACK]{eigs}()}.
}
\keyword{array}

