% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rATTAINS_caching.R
\docType{data}
\name{rATTAINS_caching}
\alias{rATTAINS_caching}
\alias{actions_cache}
\alias{au_cache}
\alias{assessments_cache}
\alias{dv_cache}
\alias{huc12_cache}
\alias{plans_cache}
\alias{state_cache}
\alias{surveys_cache}
\title{rATTAINS caching}
\value{
None
}
\description{
Manage data caches
}
\details{
To get the cache directory for a data source, see the method
\code{x$cache_path_get()}

\code{cache_delete} only accepts 1 file name, while \code{cache_delete_all} doesn't
accept any names, but deletes all files. For deleting many specific files,
use \code{cache_delete} in a \code{\link[=lapply]{lapply()}} type call

Note that cached files will continue to be used until they are deleted. You
should occasionally delete all cached files.
}
\section{Useful user functions}{


Assuming x is a \code{HoardClient} class object, e.g., \code{actions_cache}
\itemize{
\item \code{x$cache_path_get()} get cache path
\item \code{x$cache_path_set()} set cache path
\item \code{x$list()} returns a character vector of full path file names
\item \code{x$files()} returns file objects with metadata
\item \code{x$details()} returns files with details
\item \code{x$delete()} delete specific files
\item \code{x$delete_all()} delete all files, returns nothing
}
}

\section{Caching objects for each data source}{

\itemize{
\item \code{actions()}: \code{actions_cache}
\item \code{assessments()}: \code{assessments_cache}
\item \code{assessment_units()}: \code{au_cache}
\item \code{domain_values()}: \code{dv_cache}
\item \code{huc12_summary()}: \code{huc12_cache}
\item \code{plans()}: \code{plans_cache}
\item \code{state_summary()}: \code{state_cache}
\item \code{surveys()}: \code{surveys_cache}
}
}

\keyword{datasets}
