% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_StockEvent.R,
%   R/class_StockEvent_setters.R
\name{initialize,StockEvent-method}
\alias{initialize,StockEvent-method}
\alias{stockEvent}
\alias{setStockGraph}
\alias{setStockGraph,StockEvent,AmGraphOrCharacterOrMissing-method}
\title{Initialize a StockEvent}
\usage{
\S4method{initialize}{StockEvent}(.Object, backgroundAlpha = 1, stockGraph, ...)

stockEvent(backgroundAlpha = 1, stockGraph, ...)

setStockGraph(.Object, stockGraph = NULL, ...)

\S4method{setStockGraph}{StockEvent,AmGraphOrCharacterOrMissing}(.Object, stockGraph = NULL, ...)
}
\arguments{
\item{.Object}{\linkS4class{StockEvent}.}

\item{backgroundAlpha}{\code{numeric}.}

\item{stockGraph}{\linkS4class{AmGraph} created with stockGraph(*).
This is the graph on which event will be displayed.
You can use a reference to the stock graph object or id of the graph.}

\item{...}{other properties of StockEvent.}
}
\value{
(updated) argument .Object of class \linkS4class{StockEvent}.
}
\description{
Use the constructor to create the object
or update an existing one with the setters.
}
\examples{
new("StockEvent")
stockEvent()
setStockGraph(.Object = stockEvent(), id = "stockGraph1", balloonText = "balloonText")
# equivalent to:
stockGraph_obj <- stockGraph(id = "stockGraph1", balloonText = "balloonText")
setStockGraph(.Object = stockEvent(), stockGraph = stockGraph_obj)
# if stockGraph_obj has already been added to the chart:
setStockGraph(.Object = stockEvent(), stockGraph = "stockGraph1")
}
