% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_Guide.R, R/class_Guide_setters.R
\docType{methods}
\name{initialize,Guide-method}
\alias{initialize,Guide-method}
\alias{guide}
\alias{setFillAlpha}
\alias{setFillAlpha,Guide,numeric-method}
\alias{setValueAxis,Guide,ValueAxisOrCharacterOrMissing-method}
\title{Initializes a Guide}
\usage{
\S4method{initialize}{Guide}(.Object, fillAlpha, valueAxis, value, ...)

guide(fillAlpha, valueAxis, value, ...)

setFillAlpha(.Object, fillAlpha)

\S4method{setFillAlpha}{Guide,numeric}(.Object, fillAlpha)

\S4method{setValueAxis}{Guide,ValueAxisOrCharacterOrMissing}(.Object,
  valueAxis = NULL, ...)
}
\arguments{
\item{.Object}{\linkS4class{Guide}}

\item{fillAlpha}{\code{numeric}, 
specifies if a grid line is placed on the center of a cell or on the beginning of a cell.
Possible values are: "start" and "middle"
This setting doesn't work if parseDates is set to TRUE.}

\item{valueAxis}{\linkS4class{ValueAxis} class.
As you can add guides directly to the chart, you might need to specify 
which value axis should be used.}

\item{value}{\code{numeric}.}

\item{...}{other properties of Guide.}
}
\description{
Uses the constructor to create the object
or update an existing one with the setters.
}
\examples{
# --- method initialize
new("Guide", fillAlpha = 0.1, gridThickness = 1, value = 1)

# --- constructor
guide(fillAlpha = .4, value = 1)
guide(fillAlpha = .4, adjustBorderColor = TRUE, gridThickness = 1)

setFillAlpha(.Object = guide(), fillAlpha = 1)
valueAxis_obj <- valueAxis(test = "foo")
setValueAxis(.Object = guide(), valueAxis = valueAxis_obj)
}
