% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amScatterChart.R
\name{amScatterChart}
\alias{amScatterChart}
\title{HTML widget displaying a scatter chart}
\usage{
amScatterChart(
  data,
  data2 = NULL,
  xValue,
  yValues,
  yValueNames = NULL,
  hline = NULL,
  vline = NULL,
  xLimits = NULL,
  yLimits = NULL,
  expandX = 0,
  expandY = 5,
  Xformatter = ifelse(isDate, "yyyy-MM-dd", "#."),
  Yformatter = "#.",
  trend = FALSE,
  chartTitle = NULL,
  theme = NULL,
  draggable = FALSE,
  tooltip = NULL,
  pointsStyle = NULL,
  backgroundColor = NULL,
  xAxis = NULL,
  yAxis = NULL,
  scrollbarX = FALSE,
  scrollbarY = FALSE,
  legend = NULL,
  caption = NULL,
  image = NULL,
  button = NULL,
  cursor = FALSE,
  width = NULL,
  height = NULL,
  export = FALSE,
  chartId = NULL,
  elementId = NULL
)
}
\arguments{
\item{data}{a dataframe}

\item{data2}{\code{NULL} or a dataframe used to update the data with the
button; its column names must include the column names of \code{data}
given in \code{yValues} as well as the column name given in \code{xValue};
moreover it must have the same number of rows as \code{data} and its rows
must be in the same order as those of \code{data}}

\item{xValue}{name of the column of \code{data} to be used on the x-axis}

\item{yValues}{name(s) of the column(s) of \code{data} to be used on the
y-axis}

\item{yValueNames}{names of the variables on the y-axis,
to appear in the legend;
\code{NULL} to use \code{yValues} as names, otherwise a named list of the
form \code{list(yvalue1 = "ValueName1", yvalue2 = "ValueName2", ...)} where
\code{yvalue1}, \code{yvalue2}, ... are the column names given in
\code{yValues} and \code{"ValueName1"}, \code{"ValueName2"}, ... are the
desired names to appear in the legend}

\item{hline}{an optional horizontal line to add to the chart; it must be a
named list of the form \code{list(value = h, line = settings)} where
\code{h} is the "intercept" and \code{settings} is a list of settings
created with \code{\link{amLine}}}

\item{vline}{an optional vertical line to add to the chart; it must be a
named list of the form \code{list(value = v, line = settings)} where
\code{v} is the "intercept" and \code{settings} is a list of settings
created with \code{\link{amLine}}}

\item{xLimits}{range of the x-axis, a vector of two values specifying
the left and the right limits of the x-axis; \code{NULL} for default values}

\item{yLimits}{range of the y-axis, a vector of two values specifying
the lower and the upper limits of the y-axis; \code{NULL} for default values}

\item{expandX}{if \code{xLimits = NULL}, a percentage of the range of the
x-axis used to expand this range}

\item{expandY}{if \code{yLimits = NULL}, a percentage of the range of the
y-axis used to expand this range}

\item{Xformatter}{a
\href{https://www.amcharts.com/docs/v4/concepts/formatters/formatting-numbers/}{number formatting string}
if \code{xValue} is set to a numeric column of \code{data};
it is used to format the values displayed in the cursor tooltips if
\code{cursor = TRUE}, the labels of the x-axis unless you specify
your own formatter in the \code{labels} field of the list passed on to
the \code{xAxis} option, and the values displayed in the tooltips unless
you specify your own tooltip text;
if \code{xValue} is set to a date column of \code{data}, this option should
be set to a
\href{https://www.amcharts.com/docs/v4/concepts/formatters/formatting-date-time/}{date formatting string},
and it has an effect only on the values displayed in the tooltips (unless
you specify your own tooltip text); formatting the dates on the x-axis is
done via the \code{labels} field of the list passed on to the \code{xAxis}
option}

\item{Yformatter}{a
\href{https://www.amcharts.com/docs/v4/concepts/formatters/formatting-numbers/}{number formatting string};
it is used to format the values displayed in the cursor tooltips if
\code{cursor = TRUE}, the labels of the y-axis unless you specify
your own formatter in the \code{labels} field of the list passed on to
the \code{yAxis} option, and the values displayed in the tooltips unless
you specify your own tooltip text (see the first example of
\code{\link{amBarChart}} for the way to set
a number formatter in the tooltip text)}

\item{trend}{option to request trend lines and to set their settings;
\code{FALSE} for no trend line, otherwise a named list of the form
\code{list(yvalue1 = trend1, yvalue2 = trend2, ...)} where
\code{trend1}, \code{trend2}, ... are lists with the following fields:
\describe{
  \item{\code{method}}{
    the modelling method, can be \code{"lm"}, \code{"lm.js"}, \code{"nls"},
    \code{"nlsLM"}, or \code{"loess"}; \code{"lm.js"} performs a polynomial
    regression in JavaScript, its advantage is that the fitted regression
    line is updated when the points are dragged
  }
  \item{\code{formula}}{
    a formula passed on to the modelling function for methods \code{"lm"},
    \code{"nls"} or \code{"nlsLM"}; the
    lefthandside of this formula must always be \code{y}, and its
    righthandside must be a symbolic expression depending on \code{x} only,
    e.g. \code{y ~ x}, \code{y ~ x + I(x^2)}, \code{y ~ poly(x,2)}
  }
  \item{\code{interval}}{
    effective for methods \code{"lm"} and \code{"lm.js"} only;
    a list with five possible fields:
    \code{type} can be \code{"confidence"} or \code{"prediction"},
    \code{level} is the confidence or prediction level (number between 0
    and 1), \code{color} is the color of the shaded area, \code{opacity}
    is the opacity of the shaded area (number between 0 and 1),
    \code{tensionX} and \code{tensionY} to control the smoothing
    (see \code{\link{amLine}})
  }
  \item{\code{order}}{
    the order of the polynomial regression when \code{method = "lm.js"}
  }
  \item{\code{method.args}}{
    a list of additional arguments passed on to the modelling function
    defined by \code{method} for methods \code{"nls"}, \code{"nlsLM"} or
    \code{"loess"}, e.g. \code{method.args = list(span = 0.3)} for
    method \code{"loess"}
  }
  \item{\code{style}}{
    a list of settings for the trend line created with \code{\link{amLine}}
  }
}
it is also possible to request the same kind of trend lines for all series
given by the \code{yValues} argument, by passing a list of the
form \code{list("_all" = trendconfig)}, e.g.
\code{list("_all" = list(method = "lm", formula = y ~ 0+x, style = amLine()))}}

\item{chartTitle}{chart title, it can be \code{NULL} or \code{FALSE} for no
title, a character string,
a list of settings created with \code{\link{amText}}, or a list with two
fields: \code{text}, a list of settings created with \code{\link{amText}},
and \code{align}, can be \code{"left"}, \code{"right"} or \code{"center"}}

\item{theme}{theme, \code{NULL} or one of \code{"dataviz"},
\code{"material"}, \code{"kelly"}, \code{"dark"}, \code{"moonrisekingdom"},
\code{"frozen"}, \code{"spiritedaway"}, \code{"patterns"},
\code{"microchart"}}

\item{draggable}{\code{TRUE}/\code{FALSE} to enable/disable dragging of
all lines, otherwise a named list of the form
\code{list(yvalue1 = TRUE, yvalue2 = FALSE, ...)} to enable/disable the
dragging for each series corresponding to a column given in \code{yValues}}

\item{tooltip}{settings of the tooltips; \code{NULL} for default,
\code{FALSE} for no tooltip, otherwise a named list of the form
\code{list(yvalue1 = settings1, yvalue2 = settings2, ...)} where
\code{settings1}, \code{settings2}, ... are lists created with
\code{\link{amTooltip}}; this can also be a
single list of settings that will be applied to each series,
or a just a string for the text to display in the tooltip}

\item{pointsStyle}{settings of the points style; \code{NULL} for default,
otherwise a named list of the form
\code{list(yvalue1 = settings1, yvalue2 = settings2, ...)} where
\code{settings1}, \code{settings2}, ... are lists created with
\code{\link{amCircle}}, \code{\link{amTriangle}} or
\code{\link{amRectangle}}; this can also be a
single list of settings that will be applied to each series}

\item{backgroundColor}{a color for the chart background; it can be given by
the name of a R color, the name of a CSS
color, e.g. \code{"aqua"} or \code{"indigo"}, an HEX code like
\code{"#ff009a"}, a RGB code like \code{"rgb(255,100,39)"}, or a HSL code
like \code{"hsl(360,11,255)"}}

\item{xAxis}{settings of the x-axis given as a list, or just a string
for the axis title; the list of settings has five possible fields:
a field \code{title}, a list of settings for the axis title created
with \code{\link{amText}},
a field \code{labels}, a list of settings for the axis labels created
with \code{\link{amAxisLabels}},
a field \code{adjust}, a number defining the vertical adjustment of
the axis (in pixels),
a field \code{gridLines}, a list of settings for the grid lines created
with \code{\link{amLine}},
and a field \code{breaks} to control the axis breaks, an R object created
with \code{\link{amAxisBreaks}}}

\item{yAxis}{settings of the y-axis given as a list, or just a string
for the axis title; the list of settings has five possible fields:
a field \code{title}, a list of settings for the axis title created
with \code{\link{amText}},
a field \code{labels}, a list of settings for the axis labels created
with \code{\link{amAxisLabels}},
a field \code{adjust}, a number defining the horizontal adjustment of
the axis (in pixels),
a field \code{gridLines}, a list of settings for the grid lines created
with \code{\link{amLine}},
and a field \code{breaks} to control the axis breaks, an R object created
with \code{\link{amAxisBreaks}}}

\item{scrollbarX}{logical, whether to add a scrollbar for the x-axis}

\item{scrollbarY}{logical, whether to add a scrollbar for the y-axis}

\item{legend}{\code{FALSE} for no legend, \code{TRUE} for a legend with
default settings, or a list of settings created with
\code{\link{amLegend}}}

\item{caption}{\code{NULL} or \code{FALSE} for no caption, a formatted
text created with \code{\link{amText}}, or a list with two fields:
\code{text}, a list created with \code{\link{amText}}, and \code{align},
can be \code{"left"}, \code{"right"} or \code{"center"}}

\item{image}{option to include an image at a corner of the chart;
\code{NULL} or \code{FALSE} for no image, otherwise a named list with four
possible fields: the field \code{image} (required) is a list created with
\code{\link{amImage}},
the field \code{position} can be \code{"topleft"}, \code{"topright"},
\code{"bottomleft"} or \code{"bottomright"}, the field \code{hjust}
defines the horizontal adjustment, and the field \code{vjust} defines
the vertical adjustment}

\item{button}{\code{NULL} for the default, \code{FALSE} for no button,
or a list of settings created with \code{\link{amButton}}; this button is
used to replace the current data with \code{data2}}

\item{cursor}{option to add a cursor on the chart; \code{FALSE} for no
cursor, \code{TRUE} for a cursor for both axes with default settings
for the axes tooltips,
otherwise a named list with four possible fields: a field
\code{axes} to specify the axes for which the cursor is requested, can be
\code{"x"}, \code{"y"}, or \code{"xy"},
a field \code{tooltip} to set the style of the axes tooltips, this
must be a list of settings created with \code{\link{amTooltip}},
a field \code{extraTooltipPrecision}, a named list of the form
\code{list(x = i, y = j)} where \code{i} and \code{j} are the desired
numbers of additional decimals for the tooltips on the x-axis and
on the y-axis respectively, and a field \code{modifier}, a list with two
possible fields, \code{x} and \code{y}, which defines modifiers for the
values displayed in the tooltips; a modifier is some JavaScript code
given a string, which performs a modification of a string named
\code{text}; see the first example of \code{\link{amLineChart}}
for an example of \code{modifier}}

\item{width}{the width of the chart, e.g. \code{"600px"} or \code{"80\%"};
ignored if the chart is displayed in Shiny, in which case the width is
given in \code{\link{amChart4Output}}}

\item{height}{the height of the chart, e.g. \code{"400px"};
ignored if the chart is displayed in Shiny, in which case the height is
given in \code{\link{amChart4Output}}}

\item{export}{logical, whether to enable the export menu}

\item{chartId}{a HTML id for the chart}

\item{elementId}{a HTML id for the container of the chart; ignored if the
chart is displayed in Shiny, in which case the id is given by the Shiny id}
}
\description{
Create a HTML widget displaying a scatter chart.
}
\examples{
# iris data: petal widths ####
dat <- iris
dat$obs <- rep(1:50, 3)
dat <- reshape2::dcast(dat, obs ~ Species, value.var = "Petal.Width")

amScatterChart(
  data = dat,
  width = "700px",
  xValue = "obs",
  yValues = c("setosa", "versicolor", "virginica"),
  draggable = FALSE,
  backgroundColor = "#30303d",
  pointsStyle = list(
    setosa = amCircle(color = "orange", strokeColor = "red"),
    versicolor = amCircle(color = "cyan", strokeColor = "blue"),
    virginica = amCircle(color = "palegreen", strokeColor = "darkgreen")
  ),
  tooltip = "obs: {valueX}\nvalue: {valueY}",
  chartTitle = amText(text = "Iris data", color = "whitesmoke"),
  xAxis = list(title = amText(text = "Observation",
                              fontSize = 21,
                              color = "silver"),
               labels = amAxisLabels(color = "whitesmoke",
                                     fontSize = 17)),
  yAxis = list(title = amText(text = "Petal width",
                              fontSize = 21,
                              color = "silver"),
               labels = amAxisLabels(color = "whitesmoke",
                                     fontSize = 14),
               gridLines = amLine(color = "whitesmoke",
                                  opacity = 0.4, width = 1)),
  Xformatter = "#",
  Yformatter = "#.0",
  caption = amText(text = "[font-style:italic]rAmCharts4[/]",
                   color = "yellow"),
  theme = "dark")


# iris data: petal widths vs petal lengths

dat <- iris
dat$obs <- rep(1:50, 3)
dat <-
  reshape2::dcast(dat, obs + Petal.Length ~ Species, value.var = "Petal.Width")

amScatterChart(
  data = dat,
  width = "700px",
  xValue = "Petal.Length",
  yValues = c("setosa", "versicolor", "virginica"),
  draggable = FALSE,
  backgroundColor = "#30303d",
  pointsStyle = list(
    setosa = amCircle(color = "orange", strokeColor = "red"),
    versicolor = amCircle(color = "cyan", strokeColor = "blue"),
    virginica = amCircle(color = "palegreen", strokeColor = "darkgreen")
  ),
  tooltip = list(
    setosa = amTooltip(
      text = "length: {valueX}\nwidth: {valueY}",
      backgroundColor = "orange",
      borderColor = "red",
      textColor = "black"
    ),
    versicolor = amTooltip(
      text = "length: {valueX}\nwidth: {valueY}",
      backgroundColor = "cyan",
      borderColor = "blue",
      textColor = "black"
    ),
    virginica = amTooltip(
      text = "length: {valueX}\nwidth: {valueY}",
      backgroundColor = "palegreen",
      borderColor = "darkgreen",
      textColor = "black"
    )
  ),
  chartTitle = amText(text = "Iris data", color = "silver"),
  xAxis = list(title = amText(text = "Petal length",
                              fontSize = 19,
                              color = "gold"),
               labels = amAxisLabels(color = "whitesmoke",
                                     fontSize = 17)),
  yAxis = list(title = amText(text = "Petal width",
                              fontSize = 19,
                              color = "gold"),
               labels = amAxisLabels(color = "whitesmoke",
                                     fontSize = 17),
               gridLines = amLine(color = "whitesmoke",
                                  opacity = 0.4, width = 1)),
  cursor = list(
    tooltip = amTooltip(backgroundColor = "lightgray"),
    extraTooltipPrecision = list(x = 1, y = 1)
  ),
  caption = amText(text = "[font-style:italic]rAmCharts4[/]",
                   color = "yellow"),
  theme = "dark")


# scatter chart with trend lines ####

Asym = 5; R0 = 1; lrc = -3/4
x <- seq(-.3, 5, len = 101)
y0 <- Asym + (R0-Asym) * exp(-exp(lrc)* x)

dat <- data.frame(
  x = x,
  y1 = y0 + rnorm(101, sd = 0.33),
  y2 = y0 + rnorm(101, sd = 0.33) + 2
)

amScatterChart(
  data = dat,
  width = "700px",
  xValue = "x",
  yValues = c("y1", "y2"),
  trend = list("_all" = list(
    method = "nls",
    formula = y ~ SSasymp(x, Asym, R0, lrc),
    style = amLine()
  )),
  draggable = FALSE,
  pointsStyle = list(
    y1 = amTriangle(
      width = 8,
      height = 8,
      strokeColor = "yellow",
      strokeWidth = 1
    ),
    y2 = amTriangle(
      width = 8,
      height = 8,
      strokeColor = "chartreuse",
      strokeWidth = 1,
      rotation = 180
    )
  ),
  chartTitle = amText(text = "Asymptotic regression model"),
  xAxis = "x",
  yAxis = "y",
  Xformatter = "#.###",
  Yformatter = "#.",
  theme = "kelly")
}
