% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codelists.R
\name{definition_search}
\alias{definition_search}
\title{This function is used to build new definition lists based on medical definitions}
\usage{
definition_search(def, medical_table = NULL, test_table = NULL,
  drug_table = NULL, lookup = NULL)
}
\arguments{
\item{def}{an object of class MedicalDefinition}

\item{medical_table}{Dataframe lookup table of clinical codes}

\item{test_table}{dataframe lookup table of test codes}

\item{drug_table}{dataframe lookup table of medication product codes}

\item{lookup}{list containing elements: "codes", "terms", "tests", "drugs", "drugcodes" (see details)}
}
\description{
This function is used to build new definition lists based on medical definitions
}
\details{
You may get an invalid multibyte string error, in which case, set fileEncoding="latin1" on
read.delim when reading in the lookup tables
Lookup tables are
}
\examples{
\dontrun{
medical_table <- read.delim("medical.txt", fileEncoding="latin1", stringsAsFactors = FALSE)
drug_table <- read.delim("product.txt", fileEncoding="latin1", stringsAsFactors = FALSE)
def2 <- import_definition_lists(system.file("extdata", "example_search.csv",
                                            package = "rpcdsearch"))
draft_lists <- definition_search(def2, medical_table, drug_table = drug_table)
}

}

