% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_CGM.R
\name{read_cgm}
\alias{read_cgm}
\title{Read in continuous glucose monitor data}
\usage{
read_cgm(
  file,
  timezero = "first",
  na.rm = TRUE,
  skip = 0,
  calib_col = NA,
  calib_tag,
  mult_sensors = FALSE,
  sensor_times = NA,
  sensor_gap = 120,
  time_col,
  gluc_col,
  time_sep = " ",
  time_format = c(dates = "m/d/y", times = "h:m:s"),
  high_ind = "High",
  high_value = 400,
  low_ind = "Low",
  low_value = 40
)
}
\arguments{
\item{file}{name of the CSV file to be read in}

\item{timezero}{set to "first" if the first glucose reading should be considered time zero and set to "midnight" if midnight of the day of the first reading should be considered time zero. Default is "first".}

\item{na.rm}{a logical that is TRUE if you wish to exclude all readings that are missing glucose values or time stamps and FALSE if not. Default is TRUE.}

\item{skip}{the number of lines in the data file to skip before beginning to read in data}

\item{calib_col}{the number or name of the column containing information regarding calibration status of each glucose entry}

\item{calib_tag}{the character value used to denote calibration rows in calib_col}

\item{mult_sensors}{a logical that is TRUE if you wish to split the data set into parts corresponding to different CGM sensors and FALSE if not. Default is FALSE.}

\item{sensor_times}{a vector of times (in the same format as the time data) that correspond to the beginning of a new CGM sensor. These times are used to split the data between multiple sensors if mult_sensors is TRUE. If sensor_times is NA, the data is split automatically at every gap of sensor_gap or more minutes.}

\item{sensor_gap}{a number specifying the minimum gap (in minutes) for which we should split the data into two pieces. Default is 120.}

\item{time_col}{the number or name of the column containing time data}

\item{gluc_col}{the number or name of the column containing glucose data}

\item{time_sep}{character that separates date from time in your time data}

\item{time_format}{specify date and time formats according to the specification used in the chron package. Default is c(dates = "m/d/y", times = "h:m:s").}

\item{high_ind}{character value that identifies high glucose values in the data. Default is "High".}

\item{high_value}{numeric value by which to replace glucose values equal to "high_ind". Default is 400.}

\item{low_ind}{character value that identifies low glucose values in the data. Default is "Low".}

\item{low_value}{numeric value by which to replace glucose values equal to "low_ind". Default is 40.}
}
\value{
A data frame with two columns: glucose values and time. This data frame can then be used with other rGV functions to calculate CGM metrics.
}
\description{
Read in continuous glucose monitor data
}
