% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kpi.R
\name{kpi_search}
\alias{kpi_search}
\title{Search for Kolada KPIs using a Kolada KPI table}
\usage{
kpi_search(kpi_df, query, column = NULL)
}
\arguments{
\item{kpi_df}{A Kolada KPI metadata table, e.g. as created by
\code{\link{get_kpi}}.}

\item{query}{A search term or a vector of search terms to filter by. Case
insensitive.}

\item{column}{(Optional) A string or character vector with the names of
columns in which to search for \code{query}.}
}
\value{
A Kolada KPI metadata table
}
\description{
Search a Kolada KPI metadata table. Only keep rows that
contain the search query. Matches against all columns or columns named with
the \code{column} parameter. For more precise matching, please use
\code{\link[dplyr:filter]{dplyr::filter}}.
}
\examples{
# Search for a single search term in a KPI table
kpis <- get_kpi(id = c("N11002", "N11003", "N11004", "N11005"))
kpi_filter <- kpi_search(kpis, "kostnad")

# Add keywords to a KPI table and search for multiple terms among
# the keywords
kpi_filter <- get_kpi(id = c("N11002", "N11003", "N11004", "N11005")) \%>\%
  kpi_bind_keywords(n = 3) \%>\%
  kpi_search(
    query = c("nettokostnad", "öppen"),
    column = c("keyword_1", "keyword_2", "keyword_3")
  )

}
