% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/espa_user.R
\name{espa_user}
\alias{espa_user}
\title{Validate Espa Credentials}
\usage{
espa_user(host = "https://espa.cr.usgs.gov/api/v1/", username = NULL,
  password = NULL)
}
\arguments{
\item{host}{the api call host. Default set to espa v1 web api}

\item{username}{default NULL, which fetches the username from the global environment. If defined otherwise, will run the api with the provided details}

\item{password}{default NULL, which fetches the password from the global environment. If defined otherwise, will run the api with the provided details}
}
\value{
logical. TRUE if user is active, FALSE if credentials are wrong or API is unresponsive
}
\description{
To check espa credentials and if espa-api is responding. Suggest to use \code{\link{espa_creds}} function to store your credentials before running this function
}
\examples{
## inputting the credentials
espa_creds("your_espaname", "secret_password")
## checking if the user is valid
espa_user() # returns FALSE

}
