% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMEA_IO.R
\name{writeMEA}
\alias{writeMEA}
\title{Exports analyzed MEA data to .txt files}
\usage{
writeMEA(mea, save.directory, mea_data, ccf_data, ...)
}
\arguments{
\item{mea}{an object of class \code{MEA} or \code{MEAlist} (see function \code{\link{readMEA}})}

\item{save.directory}{a character string naming a directory}

\item{mea_data}{logical. Should the (filtered) MEA data be included in the export}

\item{ccf_data}{logical. Should the cross correlation results be exported?}

\item{...}{further arguments passed to \code{\link[utils]{write.table}}}
}
\description{
Exports analyzed MEA data to .txt files
}
\details{
If both \code{mea_data} and \code{ccf_data} are \code{TRUE}, the cross-correlation data will be linearly interpolated to match the sampling rate of MEA data.
}
\examples{
\donttest{
## This example is excluded from test as it takes more than 10s to run
## define a regex filter for the filenames to be read
to_read = c("20[123]_*")

## read the first 4 minutes of the files
path_normal <- system.file("extdata/normal", package = "rMEA")
mea_normal <- readMEA(path_normal, namefilt = to_read, sampRate = 25, s1Col = 1, s2Col = 2,
                     s1Name = "Patient", s2Name = "Therapist",
                     idOrder = c("id","session"), idSep = "_",  skip = 1, nrow = 6000)

## perform ccf analysis
mea_ccf = MEAccf(mea_normal, lagSec = 5, winSec = 60, incSec = 30, r2Z = TRUE, ABS = TRUE)

## export data and analysis
save_path = tempdir()
writeMEA(mea_ccf, save.directory = save_path, mea_data = TRUE, ccf_data = TRUE)
}
}
