% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpraat.R
\name{tg.duplicateTier}
\alias{tg.duplicateTier}
\title{tg.duplicateTier}
\usage{
tg.duplicateTier(tg, originalInd, newInd = Inf, newTierName = "")
}
\arguments{
\item{tg}{TextGrid object}

\item{originalInd}{tier index or "name"}

\item{newInd}{new tier index (1 = the first, Inf = the last [default])}

\item{newTierName}{[optional but recommended] name of the new tier}
}
\value{
TextGrid object
}
\description{
Duplicates tier originalInd to new tier with specified index newInd
(existing tiers are shifted).
It is highly recommended to set a name to the new tier
(this can also be done later by tg.setTierName). Otherwise, both original and new tiers have the
same name which is permitted but not recommended. In such a case, we
cannot use the comfort of using tier name instead of its index in other
functions.
}
\examples{
tg <- tg.sample()
tg2 <- tg.duplicateTier(tg, "word", 1, "NEW")
tg.plot(tg2)
}
\seealso{
\code{\link{tg.duplicateTierMergeSegments}}, \code{\link{tg.setTierName}}, \code{\link{tg.removeTier}}
}
