% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpraat.R
\name{tg.insertInterval}
\alias{tg.insertInterval}
\title{tg.insertInterval}
\usage{
tg.insertInterval(tg, tierInd, tStart, tEnd, label = "")
}
\arguments{
\item{tg}{TextGrid object}

\item{tierInd}{tier index or "name"}

\item{tStart}{start time of the new interval}

\item{tEnd}{end time of the new interval}

\item{label}{[optional] label of the new interval}
}
\value{
TextGrid object
}
\description{
Inserts new interval into an empty space in interval tier:
a) Into an already existing interval with empty label (most common
situation because, e.g., a new interval tier has one empty interval from
beginning to the end.
b) Outside of existing intervals (left or right), this may create another
empty interval between.
}
\details{
In most cases, this function is the same as 1.) tgInsertBoundary(tEnd)
and 2.) tgInsertBoundary(tStart, "new label"). But, additional checks are
performed: a) tStart and tEnd belongs to the same empty interval, or
b) both times are outside of existings intervals (both left or both right).

Intersection of the new interval with more already existing (even empty)
does not make a sense and is forbidden.

In many situations, in fact, this function creates more than one interval.
E.g., let's assume an empty interval tier with one empty interval from 0 to 5 sec.
1.) We insert a new interval from 1 to 2 with label "he".
    Result: three intervals, 0-1 "", 1-2 "he", 2-5 "".
2.) Then, we insert an interval from 7 to 8 with label "lot".
    Result: five intervals, 0-1 "", 1-2 "he", 2-5 "", 5-7 "", 7-8 "lot"
    Note: the empty 5-7 "" interval is inserted because we are going
    outside of the existing tier.
3.) Now, we insert a new interval exactly between 2 and 3 with label "said".
    Result: really only one interval is created (and only the right
    boundary is added because the left one already exists):
    0-1 "", 1-2 "he", 2-3 "said", 3-5 "", 5-7 "", 7-8 "lot".
4.) After this, we want to insert another interval, 3 to 5: label "a".
    In fact, this does not create any new interval at all. Instead of
    that, it only sets the label to the already existing interval 3-5.
    Result: 0-1 "", 1-2 "he", 2-3 "said", 3-5 "a", 5-7 "", 7-8 "lot".

This function is not implemented in Praat (6.0.14). And it is very useful
for adding separate intervals to an empty area in interval tier, e.g.,
result of voice activity detection algorithm.
On the other hand, if we want continuously add new consequential
intervals, tgInsertBoundary() may be more useful. Because, in the
tgInsertInterval() function, if we calculate both boundaries separately
for each interval, strange situations may happen due to numeric round-up
errors, like 3.14*5 != 15.7. In such cases, it may be hard to obtain
precisely consequential time instances. As 3.14*5 is slightly larger than
15.7 (let's try to calculate 15.7 - 3.14*5), if you calculate tEnd of the
first interval as 3.14*5 and tStart of the second interval as 15.7, this
function refuse to create the second interval because it would be an
intersection. In the opposite case (tEnd of the 1st: 15.7, tStart of the
2nd: 3.14*5), it would create another "micro" interval between these two
slightly different time instances. Instead of that, if you insert only
one boundary using the tgInsertBoundary() function, you are safe that
only one new interval is created. But, if you calculate the "15.7" (no
matter how) and store in the variable and then, use this variable in
the tgInsertInterval() function both for the tEnd of the 1st interval and
tStart of the 2nd interval, you are safe, it works fine.
}
\examples{
tg <- tg.sample()
tg2 <- tg.insertNewIntervalTier(tg, 1, "INTERVALS")
tg2 <- tg.insertBoundary(tg2, "INTERVALS", 0.8)
tg2 <- tg.insertBoundary(tg2, "INTERVALS", 0.1, "Interval A")
tg2 <- tg.insertInterval(tg2, "INTERVALS", 1.2, 2.5, "Interval B")
\dontrun{
tg.plot(tg2)
}
}
\seealso{
\code{\link{tg.insertBoundary}}, \code{\link{tg.removeIntervalLeftBoundary}}, \code{\link{tg.removeIntervalRightBoundary}}, \code{\link{tg.removeIntervalBothBoundaries}}, \code{\link{tg.duplicateTierMergeSegments}}
}
