% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tg.R
\name{tg.insertNewPointTier}
\alias{tg.insertNewPointTier}
\title{tg.insertNewPointTier}
\usage{
tg.insertNewPointTier(tg, newInd = Inf, newTierName)
}
\arguments{
\item{tg}{TextGrid object}

\item{newInd}{new tier index (\code{1} = the first, \code{Inf} = the last [default])}

\item{newTierName}{new tier name}
}
\value{
TextGrid object
}
\description{
Inserts new point tier to the specified index (existing tiers are
shifted).
}
\examples{
\dontrun{
tg <- tg.sample()
tg2 <- tg.insertNewPointTier(tg, 1, "POINTS")
tg2 <- tg.insertPoint(tg2, "POINTS", 3, "MY POINT")
tg2 <- tg.insertNewPointTier(tg2, Inf, "POINTS2")  # the last tier
tg2 <- tg.insertPoint(tg2, "POINTS2", 2, "point in the last tier")
tg.plot(tg2)
}
}
\seealso{
\code{\link{tg.insertPoint}}, \code{\link{tg.insertNewIntervalTier}}, \code{\link{tg.duplicateTier}}, \code{\link{tg.removeTier}}
}
