% Generated by roxygen2 (4.0.2): do not edit by hand
\name{show.pref}
\alias{show.pref}
\title{Show a (partially evaluated) preference}
\usage{
show.pref(p, df = NULL)
}
\arguments{
\item{p}{The preference to be shown.}

\item{df}{(Optional) A dataframe on which the preference operates.}
}
\description{
Show a (partially evaluated) preference
}
\details{
If \code{df} is not given this function is identical to typing \code{p} on the console or calling \code{show(p)}.
This standard show function does not do any evaluation and just converts the expressions to characters.
A given dataframe causes that all expressions in \code{p} are evaluated except the attributes in \code{p},
i.e. the column names in \code{df}. The content of the dataframe \code{df} does not matter;
only \code{colnames(df)} is taken to get the "free variables" in \code{p}
}
\examples{
f <- function(x) 2*x
p <- true(cyl == f(1))

# prints 'cyl == f(x)'
p

# prints 'cyl == 2'
show.pref(p, mtcars)
}

