% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/visualize.r
\name{get_btg}
\alias{get_btg}
\alias{plot_btg}
\title{Better-Than-Graph}
\usage{
get_btg(df, pref, flip.edges = FALSE)

plot_btg(df, pref, labels = 1:nrow(df), flip.edges = FALSE)
}
\arguments{
\item{df}{A data frame.}

\item{pref}{A preference on the columns of \code{df}, see \code{\link{psel}} for details.}

\item{flip.edges}{(optional) Flips the orientation of edges,
if \code{TRUE} than arrows point from worse nodes to better nodes.}

\item{labels}{(optional) Labels for the vertices when \code{plot_btg} is used.}
}
\description{
Returns a Hasse-Diagramm of a preference order (also called the Better-Than-Graph) on a given data set
to be plotted with the igraph package or plots the graph directly.
}
\details{
The function \code{get_btg} returns a list \code{l} with the following list entries:

\describe{
  \item{\code{l$graph}}{An igraph object, created with the \code{\link{igraph}} package.}
  \item{\code{l$layout}}{A typical Hasse-diagram layout for plotting the graph, also created with igraph.}
}

To plot the resulting graph returned from \code{get_btg}, use the \code{plot} function as follows:

\code{plot(l$graph, layout = l$layout)}.

For more details, see \code{\link{igraph.plotting}} and the examples below.
The function \code{plot_btg} directly plots the Better-Than-Graph
some defaults values for e.g., vertex size.

The Hasse diagram of a preference visualizes all the better-than-relationsships on a given data set.
All edges which can be retrieved by transitivity of the order are omitted.

By default, the arrows in the diagram point from better to worse nodes w.r.t. the preference.
This means an arrow can be read as "is better than". If \code{flip.edges = TRUE} is set,
then the arrows point from worse nodes to better nodes ("is worse than").
In any case, the better nodes are plotted at the top and the worse nodes at the bottom of the diagram.

The names of the vertices are characters ranging from \code{"1"} to \code{as.character(nrow(df))}
and they correspond to the row numbers of \code{df}.
By default, these are also the labels of the vertices.
Alternatively, they can be defined manually in the \code{plot} function or
using the \code{labels} parameter of \code{plot_btg}.
}
\examples{
# pick a small data set and create preference and BTG
df <- mtcars[1:10,]
pref <- high(mpg) * low(wt)

# directly plot the BTG with row numbers as labels
plot_btg(df, pref)

# create the BTG and labels for the nodes with relevant values
btg <- get_btg(df, pref)
labels <- paste0(df$mpg, "\\n", df$wt)

# plot the graph using igraph
library(igraph)
plot(btg$graph, layout = btg$layout, vertex.label = labels,
     vertex.size = 25)

# add colors for the maxima nodes and plot again
colors <- rep(rgb(1, 1, 1), nrow(df))
colors[psel.indices(df, pref)] <- rgb(0,1,0)
plot(btg$graph, layout = btg$layout, vertex.label = labels,
     vertex.size = 25, vertex.color = colors)

# show lattice structure of 3-dimensional Pareto preference
df <- merge(merge(data.frame(x = 1:3), data.frame(y = 1:3)), data.frame(z = 1:2))
labels <- paste0(df$x, ",", df$y, ",", df$z)
btg <- get_btg(df, low(x) * low(y) * low(z))
plot(btg$graph, layout = btg$layout, vertex.label = labels,
     vertex.size = 20)
}
\seealso{
\code{\link{igraph.plotting}}
}

