% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{matern.covariance}
\alias{matern.covariance}
\title{The Matern covariance function}
\usage{
matern.covariance(h, kappa, nu, sigma)
}
\arguments{
\item{h}{Distances to evaluate the covariance function at.}

\item{kappa}{Range parameter.}

\item{nu}{Shape parameter.}

\item{sigma}{Standard deviation.}
}
\value{
A vector with the values C(h).
}
\description{
\code{matern.covariance} evaluates the Matern covariance function
\deqn{C(h) = \frac{\sigma^2}{2^{\nu-1}\Gamma(\nu)}(\kappa h)^\nu
K_\nu(\kappa h).}
}
\examples{
x <- seq(from = 0, to = 1, length.out = 101)
plot(x, matern.covariance(abs(x - 0.5), kappa = 10, nu = 1 / 5, sigma = 1),
  type = "l", ylab = "C(h)", xlab = "h"
)

}
