% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stationary1d.R
\name{precision.rSPDEobj1d}
\alias{precision.rSPDEobj1d}
\title{Get the precision matrix of rSPDEobj1d objects}
\usage{
\method{precision}{rSPDEobj1d}(
  object,
  loc = NULL,
  nu = NULL,
  kappa = NULL,
  sigma = NULL,
  range = NULL,
  tau = NULL,
  m = NULL,
  ordering = c("field", "location"),
  ldl = FALSE,
  ...
)
}
\arguments{
\item{object}{The covariance-based rational SPDE approximation,
computed using \code{\link[=matern.rational]{matern.rational()}}}

\item{loc}{If non-null, update the locations where to evaluate the model.}

\item{nu}{If non-null, update the shape parameter of the
covariance function.}

\item{kappa}{If non-null, update the range parameter of
the covariance function.}

\item{sigma}{If non-null, update the standard deviation of
the covariance function.}

\item{range}{If non-null, update the range parameter
of the covariance function.}

\item{tau}{If non-null, update the parameter tau.}

\item{m}{If non-null, update the order of the rational approximation,
which needs to be a positive integer.}

\item{ordering}{Return the matrices ordered by field or by location?}

\item{ldl}{Directly build the LDL factorization of the precision matrix?}

\item{...}{Currently not used.}
}
\value{
A list containing the precision matrix \code{Q} of the process and its derivatives if they exist, and
a matrix \code{A} that extracts the elements corresponding to the process. If \code{ldl=TRUE}, the LDL factorization
is returned instead of \code{Q}. If the locations are not ordered, the precision matrix is given for the ordered locations,
but the \code{A} matrix returns to the original order.
}
\description{
Function to get the precision matrix of a rSPDEobj1d object
}
\examples{
# Compute the covariance-based rational approximation of a
# Gaussian process with a Matern covariance function on R
sigma <- 1
nu <- 0.8
range <- 0.2

# create mass and stiffness matrices for a FEM discretization
x <- seq(from = 0, to = 1, length.out = 101)

op_cov <- matern.rational(
  loc = x, nu = nu,
  range = range, sigma = sigma, m = 2,
  parameterization = "matern"
)

# Get the precision matrix:
prec_matrix <- precision(op_cov)

}
\seealso{
\code{\link[=simulate.rSPDEobj1d]{simulate.rSPDEobj1d()}}, \code{\link[=matern.rational]{matern.rational()}}
}
