% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DailyQMapAll.R
\name{DailyQMapAll}
\alias{DailyQMapAll}
\title{Quantile mapping bias-correction}
\usage{
DailyQMapAll(stndir, stnfile, qmapdir, prjdir, SimAll, RcpNames, VarNames,
  syear_obs, eyear_obs, syear_his, eyear_his, syear_scn, eyear_scn, OWrite,
  SRadiation)
}
\arguments{
\item{stndir}{directory path for station information file}

\item{stnfile}{file name for station information}

\item{qmapdir}{directory path for bias-corrected output files}

\item{prjdir}{directory path for project}

\item{SimAll}{logical. TRUE then process goes over all the senarios available}

\item{RcpNames}{Rcp names to be uses such as rcp45, rcp85}

\item{VarNames}{variable to be used such as prcp(precipitation), tmax/tmin, solor radiation, wind etc}

\item{syear_obs}{start year of observation data}

\item{eyear_obs}{end year of observation data}

\item{syear_his}{start year of historical period}

\item{eyear_his}{end year of historical period}

\item{syear_scn}{start year of climate change scenario}

\item{eyear_scn}{end year of climate change scenario}

\item{OWrite}{Flag for overwriting output files (T: Overwrite, F: Skip)}

\item{SRadiation}{Flag for calculating solar radiation (T: Calculate, F: Skip)}
}
\description{
Do bias-correction using quantile mapping ans save the bias-corrected outputs for each weather station.
}
\examples{
\dontrun{
## Step 0. Load sample project
rSQMSampleProject() 

## Step 1. Set working environment
EnvList <- SetWorkingEnvironment(envfile = "rSQM.yaml")

## Step 2. Load climate scenario data
LoadCmip5DataFromAdss(dbdir = EnvList$dbdir, NtlCode = EnvList$NtlCode)

## Step 3. Extract daily time series
DailyExtractAll(
cmip5dir = EnvList$cmip5dir,
stndir = EnvList$stndir,
stnfile = EnvList$stnfile,
qmapdir = EnvList$qmapdir,
SimAll = EnvList$SimAll,
ModelNames = EnvList$ModelNames,
RcpNames = EnvList$RcpNames,
VarNames = EnvList$VarNames,
OWrite = EnvList$OWrite)

## Step 4. Bias-correction by simple quantile mapping
DailyQMapAll(
  stndir = EnvList$stndir,
  stnfile = EnvList$stnfile,
  qmapdir = EnvList$qmapdir,
  prjdir = EnvList$prjdir,
  SimAll = EnvList$SimAll,
  RcpNames = EnvList$RcpNames,
  VarNames = EnvList$VarNames,
  syear_obs = EnvList$syear_obs,
  eyear_obs = EnvList$eyear_obs,
  syear_his = EnvList$syear_his,
  eyear_his = EnvList$eyear_his,
  syear_scn = EnvList$syear_scn,
  eyear_scn = EnvList$eyear_scn,
  OWrite = EnvList$OWrite,
  SRadiation = EnvList$SRadiation) 
}
}
