% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GhcnDailyUpdate.R
\name{GhcnDailyUpdate}
\alias{GhcnDailyUpdate}
\title{Update Observation Data from GHCN(Global Historical Climatology Network)}
\usage{
GhcnDailyUpdate(NtlCode, stndir, syear_obs, eyear_obs)
}
\arguments{
\item{NtlCode}{2 digit country(national) code, EnvList$NtlCode}

\item{stndir}{directory where downloaded data from GHCN located, EnvList$stndir}

\item{syear_obs}{start year of observation, EnvList$syear_obs}

\item{eyear_obs}{end year of observation, EnvList$eyear_obs}
}
\description{
When user does not have own observation dataset, one can download it from GHCN. However, not recommended since NA values are too many.
}
\examples{

\dontrun{
## You can download observation data of Myanmar(MY) from 1969 to 2005 into current working directory
GhcnDailyUpdate(NtlCode="MY", stndir=getwd(), syear_obs=1969, eyear_obs=2005)
}
}
