% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_spdsplits.R
\name{plot_spdsplits}
\alias{plot_spdsplits}
\alias{plot_spdsplits.list}
\alias{plot_spdsplits.default}
\title{Plot speed by splits}
\usage{
plot_spdsplits(act_data, ...)

\method{plot_spdsplits}{list}(
  act_data,
  stoken,
  acts = 1,
  id = NULL,
  units = "metric",
  fill = "darkblue",
  ...
)

\method{plot_spdsplits}{default}(act_data, stoken, units = "metric", fill = "darkblue", ...)
}
\arguments{
\item{act_data}{an activities list object returned by \code{\link{get_activity_list}} or a \code{data.frame} returned by \code{\link{compile_activities}}}

\item{...}{arguments passed to other methods}

\item{stoken}{A \code{\link[httr]{config}} object created using the \code{\link{strava_oauth}} function}

\item{acts}{numeric indicating which activity to plot based on index in the activities list, defaults to most recent}

\item{id}{optional character vector to specify the id(s) of the activity/activities to plot, \code{acts} is ignored if provided}

\item{units}{chr string indicating plot units as either metric or imperial}

\item{fill}{chr string of fill color for profile}
}
\value{
plot of average distance for each split value in the activity
}
\description{
Plot average speed by splits for a single activity
}
\details{
The average speed per split is plotted, including a dashed line for the overall average.  The final split is typically not a complete km or mile.
}
\examples{
\dontrun{
# get my activities
stoken <- httr::config(token = strava_oauth(app_name, app_client_id, app_secret, cache = TRUE))
my_acts <- get_activity_list(stoken)

# default
plot_spdsplits(my_acts, stoken, acts = 1)
}
}
\author{
Marcus Beck
}
\concept{token}
