/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import org.python.core.Py;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.core.SyspathArchive;
import org.python.core.util.RelativeFile;

public class SyspathJavaLoader
extends ClassLoader {
    private static final char SLASH_CHAR = '/';

    public InputStream getResourceAsStream(String res) {
        Py.writeDebug("resource", "trying resource: " + res);
        PySystemState sys = Py.getSystemState();
        ClassLoader classLoader = sys.getClassLoader();
        if (classLoader != null) {
            return classLoader.getResourceAsStream(res);
        }
        classLoader = this.getClass().getClassLoader();
        InputStream ret = classLoader != null ? classLoader.getResourceAsStream(res) : ClassLoader.getSystemResourceAsStream(res);
        if (ret != null) {
            return ret;
        }
        if (res.charAt(0) == '/') {
            res = res.substring(1);
        }
        String entryRes = res;
        if (File.separatorChar != '/') {
            res = res.replace('/', File.separatorChar);
            entryRes = entryRes.replace(File.separatorChar, '/');
        }
        PyList path = sys.path;
        for (int i = 0; i < path.__len__(); ++i) {
            PyObject entry = path.__getitem__(i);
            if (entry instanceof SyspathArchive) {
                SyspathArchive archive = (SyspathArchive)entry;
                ZipEntry ze = archive.getEntry(entryRes);
                if (ze == null) continue;
                try {
                    return archive.getInputStream(ze);
                }
                catch (IOException e) {
                    continue;
                }
            }
            String dir = sys.getPath(entry.__str__().toString());
            try {
                return new BufferedInputStream(new FileInputStream(new File(dir, res)));
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        PySystemState sys = Py.getSystemState();
        ClassLoader classLoader = sys.getClassLoader();
        if (classLoader != null) {
            return classLoader.loadClass(name);
        }
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(name, true, ClassLoader.getSystemClassLoader());
            }
            catch (ClassNotFoundException e2) {
                Class<?> c = this.findLoadedClass(name);
                if (c != null) {
                    return c;
                }
                PyList path = sys.path;
                for (int i = 0; i < path.__len__(); ++i) {
                    InputStream fis = null;
                    File file = null;
                    int size = 0;
                    PyObject entry = path.__getitem__(i);
                    if (entry instanceof SyspathArchive) {
                        SyspathArchive archive = (SyspathArchive)entry;
                        String entryname = name.replace('.', '/') + ".class";
                        ZipEntry ze = archive.getEntry(entryname);
                        if (ze != null) {
                            try {
                                fis = archive.getInputStream(ze);
                                size = (int)ze.getSize();
                            }
                            catch (IOException exc) {}
                        }
                    } else {
                        String dir = entry.__str__().toString();
                        file = this.getFile(dir, name);
                        if (file != null) {
                            size = (int)file.length();
                            try {
                                fis = new FileInputStream(file);
                            }
                            catch (FileNotFoundException e3) {
                                // empty catch block
                            }
                        }
                    }
                    if (fis == null) continue;
                    try {
                        byte[] buffer = new byte[size];
                        for (int nread = 0; nread < size; nread += fis.read(buffer, nread, size - nread)) {
                        }
                        fis.close();
                        Class clazz = this.loadClassFromBytes(name, buffer);
                        return clazz;
                    }
                    catch (IOException e4) {
                        try {
                            fis.close();
                        }
                        catch (IOException e5) {}
                        continue;
                    }
                    finally {
                        try {
                            fis.close();
                        }
                        catch (IOException e6) {
                            continue;
                        }
                    }
                }
                throw new ClassNotFoundException(name);
            }
        }
    }

    private File getFile(String dir, String name) {
        String accum = "";
        boolean first = true;
        StringTokenizer t = new StringTokenizer(name, ".");
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            if (!first) {
                accum = accum + File.separator;
            }
            accum = accum + token;
            first = false;
        }
        return new RelativeFile(dir, accum + ".class");
    }

    private Class loadClassFromBytes(String name, byte[] data) {
        Class<?> c = this.defineClass(name, data, 0, data.length);
        this.resolveClass(c);
        Compiler.compileClass(c);
        return c;
    }
}

