% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_recordstreemap.R
\name{plot_recordstreemap}
\alias{plot_recordstreemap}
\title{Treemap of records data}
\usage{
plot_recordstreemap(x, groupvar = "country", log = TRUE)
}
\arguments{
\item{x}{an object of class "\code{records}", see \link{symbiota}}

\item{groupvar}{character of grouping variable, e.g., Country}

\item{log}{logical whether data should be log-transformed}

\item{...}{further arguments may be passed to \link{treemap}}
}
\value{
Map (using treemap package)
}
\description{
Treemap of records data
}
\details{
Makes use of R package 'treemap'
}
\examples{
\dontrun{
am.dist <- symbiota(taxon = "Amanita muscaria", db = "MyCoPortal")
head(recordsTable(am.dist))
plot_recordstreemap(am.dist, log = FALSE)
}
}
\author{
Franz-Sebastian Krah
}
