% Generated by roxygen2 (4.0.2): do not edit by hand
\name{ttl}
\alias{ttl}
\title{Tensor Times List}
\usage{
ttl(tnsr, list_mat, ms = NULL)
}
\arguments{
\item{tnsr}{Tensor object with K modes}

\item{list_mat}{a list of matrices}

\item{ms}{a vector of modes to contract on (order should match the order of \code{list_mat})}
}
\value{
Tensor object with K modes
}
\description{
Contracted (m-Mode) product between a Tensor of arbitrary number of modes and a list of matrices. The result is folded back into Tensor.
}
\details{
Performs \code{ttm} repeated for a single Tensor and a list of matrices on multiple modes. For instance, suppose we want to do multiply a Tensor object \code{tnsr} with three matrices \code{mat1}, \code{mat2}, \code{mat3} on modes 1, 2, and 3. We could do \code{ttm(ttm(ttm(tnsr,mat1,1),mat2,2),3)}, or we could do \code{ttl(tnsr,list(mat1,mat2,mat3),c(1,2,3))}. The order of the matrices in the list should obviously match the order of the modes. This is a common operation for various Tensor decompositions such as CP and Tucker. For the math on the m-Mode Product, see Kolda and Bader (2009).
}
\note{
The returned Tensor does not drop any modes equal to 1.
}
\examples{
tnsr <- new("Tensor",3L,c(3L,4L,5L),data=runif(60))
lizt <- list('mat1' = matrix(runif(30),ncol=3),
'mat2' = matrix(runif(40),ncol=4),
'mat3' = matrix(runif(50),ncol=5))
ttl(tnsr,lizt,ms=c(1,2,3))
}
\references{
T. Kolda, B. Bader, "Tensor decomposition and applications". SIAM Applied Mathematics and Applications 2009.
}
\seealso{
\code{\link{ttm}}
}

