% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rTensor_Class.R
\docType{methods}
\name{modeMean-methods}
\alias{modeMean-methods}
\alias{modeMean}
\alias{modeMean,Tensor-method}
\title{Tensor Mean Across Single Mode}
\usage{
modeMean(tnsr, m, drop)

\S4method{modeMean}{Tensor}(tnsr, m = NULL, drop = FALSE)
}
\arguments{
\item{tnsr}{the Tensor instance}

\item{m}{the index of the mode to average across}

\item{drop}{whether or not mode m should be dropped}
}
\value{
K-1 or K Tensor, where \code{K = x@num_modes}
}
\description{
Given a mode for a K-tensor, this returns the K-1 tensor resulting from taking the mean across that particular mode.
}
\details{
\code{modeMean(tnsr,m=NULL,drop=FALSE)}
}
\examples{
tnsr <- rand_tensor()
modeMean(tnsr,1,drop=TRUE)
}
\seealso{
\code{\link{modeSum}}
}
