% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_qsm.R
\name{plot_qsm}
\alias{plot_qsm}
\title{Plot QSM}
\usage{
plot_qsm(
  cylinder,
  radius = NULL,
  cyl_color = NULL,
  cyl_palette = NULL,
  cyl_sides = 8,
  cloud = NULL,
  pt_color = NULL,
  pt_size = NULL,
  axes = TRUE,
  hover = FALSE
)
}
\arguments{
\item{cylinder}{QSM cylinder data frame}

\item{radius}{Vector of cylinder radii. Defaults to modified cylinders from the cylinder data frame.}

\item{cyl_color}{Optional cylinder color parameter. Colors must be a single hex color, or a vector or column of hex colors with the same length as the cylinder data frame.}

\item{cyl_palette}{Optional color palette for numerical data. Palettes include: viridis, inferno, plasma, magma, cividis, and rainbow.}

\item{cyl_sides}{The number of sides in the polygon cross section. Defaults to 8, but can be increased to improve visual smoothness.}

\item{cloud}{Point cloud data frame where the first three columns are the x, y, and z coordinates in the same coordinate system as the QSM.}

\item{pt_color}{Color of the point cloud. Defaults to black.}

\item{pt_size}{Size of the points as a number. Defaults to 0.1.}

\item{axes}{Show plot axes. Defaults to TRUE.}

\item{hover}{Show cylinder ID and branch on mouse hover. Defaults to FALSE.}
}
\value{
A rgl QSM plot
}
\description{
Plots QSM cylinders using the rgl library
}
\examples{
\donttest{

## TreeQSM Processing Chain
file <- system.file("extdata/QSM.mat", package = "rTwig")
qsm <- import_qsm(file)
cylinder <- qsm$cylinder
cylinder <- update_cylinders(cylinder)
cylinder <- correct_radii(cylinder, twigRad = 4.23)
plot_qsm(cylinder)

## SimpleForest Processing Chain
file <- system.file("extdata/QSM.csv", package = "rTwig")
cylinder2 <- read.csv(file)
cylinder2 <- update_cylinders(cylinder2)
cylinder2 <- correct_radii(cylinder2, twigRad = 4.23)
plot_qsm(cylinder2)

## All Parameters
file2 <- system.file("extdata/cloud.txt", package = "rTwig")
cloud <- read.table(file2, header = FALSE)

plot_qsm(
  cylinder,
  radius = cylinder$UnmodRadius,
  cyl_color = cylinder$GrowthLength,
  cyl_palette = "viridis",
  cyl_sides = 100,
  cloud = cloud,
  pt_color = "white",
  pt_size = 1,
  axes = FALSE,
  hover = TRUE
)

}

}
