% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranki.R
\docType{package}
\name{ranki}
\alias{ranki}
\title{Estimation of ranks}
\usage{
ranki(datap)
}
\arguments{
\item{datap}{The data set}
}
\description{
Proposes a new ranking algorithm that utilizes a "Y*WAASB" biplot generated from the 'metan' package. The aim of the package is to effectively distinguish the top-ranked genotypes. For a detailed explanation of the process of obtaining a "Y*WAASB" biplot and the related data, please refer to the manual included in this package as well as the study by Olivoto & Lúcio (2020) \doi{10.1111/2041-210X.13384}. In this context, "WAASB" refers to the "Weighted Average of Absolute Scores" provided by Olivoto et al. (2019) \doi{10.2134/agronj2019.03.0220}, which quantifies the stability of genotypes across different environments using linear mixed-effect models. In order to run the package, it is necessary to extract the "WAASB" coefficients using the 'metan' package.

Estimates a new index for simultaneous selection of genotypes for trait and WAASB index. This can be compared with WAASBY index of Olivoto (2019). We suggest users handle the missing data in inputs before considering analyses, due rank codes dose not implement a widespread algorithm to do this task.
}
\details{
{The \code{rank} function estimates rank of genotypes}
}
\examples{
data(maize)
ranki(maize)

}
\references{
Olivoto, T., et al. (2019). \emph{Mean Performance and Stability in Multi-Environment Trials I: Combining Features of AMMI and BLUP Techniques}. Agronomy Journal, 111, 1-12. https://doi.org/10.2134/agronj2019.03.0220
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/abeyran/Stability1}
  \item Report bugs at \url{https://github.com/abeyran/Stability1/issues}
}

}
\author{
Ali Arminian (Ph.D.) Plant Geneticist and Breeder

Maintainer: Ali Arminian <abeyran@gmail.com>
}
\keyword{package}
