% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{createFullHaplotype}
\alias{createFullHaplotype}
\title{Anchor gene haplotype inference}
\usage{
createFullHaplotype(
  clip_db,
  toHap_col = c("v_call", "d_call"),
  hapBy_col = "j_call",
  hapBy = "IGHJ6",
  toHap_GERM,
  relative_freq_priors = TRUE,
  kThreshDel = 3,
  rmPseudo = TRUE,
  deleted_genes = c(),
  nonReliable_Vgenes = c(),
  min_minor_fraction = 0.3,
  chain = c("IGH", "IGK", "IGL")
)
}
\arguments{
\item{clip_db}{a \code{data.frame} in AIRR format. See details.}

\item{toHap_col}{a vector of column names for which a haplotype should be inferred. Default is v_call and d_call}

\item{hapBy_col}{column name of the anchor gene. Default is j_call}

\item{hapBy}{a string of the anchor gene name. Default is IGHJ6.}

\item{toHap_GERM}{a vector of named nucleotide germline sequences matching the allele calls in \code{toHap_col} columns in clip_db.}

\item{relative_freq_priors}{if TRUE, the priors for Bayesian inference are estimated from the relative frequencies in clip_db. Else, priors are set to \code{c(0.5,0.5)}. Defualt is TRUE}

\item{kThreshDel}{the minimum lK (log10 of the Bayes factor) to call a deletion. Defualt is 3.}

\item{rmPseudo}{if TRUE non-functional and pseudo genes are removed. Defualt is TRUE.}

\item{deleted_genes}{double chromosome deletion summary table. A \code{data.frame} created by \code{deletionsByBinom}.}

\item{nonReliable_Vgenes}{a list of known non reliable gene assignments. A \code{list} created by \code{nonReliableVGenes}.}

\item{min_minor_fraction}{the minimum minor allele fraction to be used as an anchor gene. Default is 0.3}

\item{chain}{the IG chain: IGH,IGK,IGL. Default is IGH.}
}
\value{
A \code{data.frame}, in which each row is the haplotype inference summary of a gene from the column selected in \code{toHap_col}.

The output containes the following columns:
\itemize{
 \item \code{subject}:        the subject name.
 \item \code{gene}:           the gene name.
 \item Anchor gene allele 1:  the haplotype inference for chromosome one. The column name is the anchor gene with the first allele.
 \item Anchor gene allele 2:  the haplotype inference for chromosome two. The column name is the anchor gene with the second allele.
 \item \code{alleles}:        allele calls for the gene.
 \item \code{proirs_row}:     priors based on relative allele usage of the anchor gene.
 \item \code{proirs_col}:     priors based on relative allele usage of the inferred gene.
 \item \code{counts1}:        the appereance count on each chromosome of the first allele from \code{alleles}, the counts are seperated by a comma.
 \item \code{k1}:             the Bayesian factor value for the first allele (from \code{alleles}) inference.
 \item \code{counts2}:        the appereance count on each chromosome of the second allele from \code{alleles}, the counts are seperated by a comma.
 \item \code{k2}:             the Bayesian factor value for the second allele (from \code{alleles}) inference.
 \item \code{counts3}:        the appereance count on each chromosome of the third allele from \code{alleles}, the counts are seperated by a comma.
 \item \code{k3}:             the Bayesian factor value for the third allele (from \code{alleles}) inference.
 \item \code{counts4}:        the appereance count on each chromosome of the fourth allele from \code{alleles}, the counts are seperated by a comma.
 \item \code{k4}:             the Bayesian factor value for the fourth allele (from \code{alleles}) inference.
}
}
\description{
The \code{createFullHaplotype} functions infers haplotype based on an anchor gene.
}
\details{
Function accepts a \code{data.frame} in AIRR format (\url{https://changeo.readthedocs.io/en/stable/standard.html}) containing the following columns:
\itemize{
  \item \code{'subject'}: The subject name
  \item \code{'v_call'}: V allele call(s) (in an IMGT format)
  \item \code{'d_call'}: D allele call(s) (in an IMGT format, only for heavy chains)
  \item \code{'j_call'}: J allele call(s) (in an IMGT format)
}
}
\examples{
# Load example data and germlines
data(samples_db, HVGERM, HDGERM)

# Selecting a single individual
clip_db = samples_db[samples_db$subject=='I5', ]

# Infering haplotype
haplo_db = createFullHaplotype(clip_db,toHap_col=c('v_call','d_call'),
hapBy_col='j_call',hapBy='IGHJ6',toHap_GERM=c(HVGERM,HDGERM))


}
