% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphic_functions.R
\name{plotDeletionsByVpooled}
\alias{plotDeletionsByVpooled}
\title{Graphical output for single chromosome D or J gene deletions according to V pooled method}
\usage{
plotDeletionsByVpooled(
  del.df,
  chain = c("IGH", "IGK", "IGL"),
  K_ranges = c(3, 7)
)
}
\arguments{
\item{del.df}{a \code{data.frame} created by \code{deletionsByVpooled}}

\item{chain}{the IG chain: IGH,IGK,IGL. Default is IGH..}

\item{K_ranges}{vector of one or two integers for log(K) certainty level thresholds}
}
\value{
A single chromosome deletion visualization.
}
\description{
The \code{plotDeletionsByVpooled} function generates a graphical output for single chromosome D or J gene deletions (for heavy chain only).
}
\details{
A \code{data.frame} created by \code{deletionsByVpooled}.
}
\examples{
\donttest{
# Load example data and germlines
data(samples_db)
del_db <- deletionsByVpooled(samples_db)
plotDeletionsByVpooled(del_db)
}
}
