% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poversample.R
\name{rs_IDs}
\alias{rs_IDs}
\title{Polynomial color coding scheme generator}
\usage{
rs_IDs(total.length, redundancy, alphabet, available.colors = NULL)
}
\arguments{
\item{total.length}{the number of unique positions to be marked on the animal. (This can be thought of as the total number of positions on which color bands or paint marks will be applied.) Note: Reed-Solomon coding requires the total length of the ID to be less than or equal to the value of \code{alphabet}.}

\item{redundancy}{the number of erasures that can occur without disrupting surety of unique identification. This value determines how robust the scheme is to erasures.}

\item{alphabet}{an integer representing the 'alphabet size.' This is the number of unique markings (think different paint colors, symbols, or varieties of bands) at your disposal. Note: Reed-Solomon coding requires this value to be a prime number. If a non-prime is entered, the function will automatically adjust it to the nearest previous prime.}

\item{available.colors}{an optional list of strings that contains the names of the unique markings which compose the given 'alphabet' (e.g. "blue", "red", "yellow", etc.). If left blank, the mapping can be done at any later time using \code{\link{codes_to_colors}}. Additionally, the length of this list must match the 'alphabet size' given above.}
}
\value{
a list containing the maximum possible number of unique ID codes that fit the provided parameters.
}
\description{
Creates color (or symbol) coding schemes used to mark and identify individual animals using polynomial oversampling based on Reed-Solomon error-correction codes. The codes are robust to an arbitrary number of color-slot erasures.
}
\examples{
total.length <- 6  #we have six positions to mark,
redundancy <- 2    #we want surety even with two erasures,
alphabet <- 5      #and we currently have five types of paint in stock

 #This gives a warning because rs_IDs() doesn't
 #allow 'total.length' to be larger than 'alphabet'
codes <- rs_IDs(total.length, redundancy, alphabet)
length(codes)

 #Now the output should be the same as above, but no warning is issued.
codes <- rs_IDs(total.length = 5, redundancy, alphabet)
length(codes)

 #Let's make those into human-readable color sequences
color.names <- c("blue","red","pink-striped-orange", "yellow", "green")
codes_to_colors(codes, color.names)

}
\references{
For information on \href{https://en.wikipedia.org/wiki/Reed-Solomon_error_correction}{Reed-Solomon error correction}.
For information on \href{https://en.wikipedia.org/wiki/Erasure_code#Polynomial_oversampling}{polynomial oversampling}.
}
\seealso{
\code{\link{brute_IDs}}, \code{\link{tweaked_IDs}}, \code{\link{simple_IDs}}. Also see the vignette \href{../doc/loosebirdtag.html}{\code{loosebirdtag}} for demonstrations and additional uses.

If an appropriate argument for \code{available.colors} is provided, each code will be a sequence of strings, otherwise, each code will be a sequence of numeric values.
}
\author{
Andrew Burchill, \email{andrew.burchill@asu.edu}
}
