% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{mutate_ext}
\alias{mutate_ext}
\title{Add transformed variables to a data frame with the option to include a custom variable name extension}
\usage{
mutate_ext(.tbl, .funs, ..., .ext = "", .vars = c())
}
\arguments{
\item{.tbl}{Data frame to add transformed variables to}

\item{.funs}{Function(s) to apply (e.g., funs(log))}

\item{...}{Variables to transform}

\item{.ext}{Extension to add for each variable}

\item{.vars}{A list of columns generated by dplyr::vars(), or a character vector of column names, or a numeric vector of column positions.}
}
\description{
Add transformed variables to a data frame with the option to include a custom variable name extension
}
\details{
Wrapper for dplyr::mutate_at that allows custom variable name extensions
}
\examples{
mutate_ext(mtcars, funs(log), mpg, cyl, .ext = "_ln")
mutate_ext(mtcars, funs(log), .ext = "_ln")
mutate_ext(mtcars, funs(log))
mutate_ext(mtcars, funs(log), .ext = "_ln", .vars = vars(mpg, cyl))

}
